/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.security.Key;
import java.util.Map;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.informationsystem.model.reference.properties.Vault;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;

public class VaultOrient
extends ODocument
implements Vault {
    protected String decryptedValue;
    protected String dbEncryptedValue;
    protected String contextEncryptedValue;

    public VaultOrient() {
        super("Vault");
    }

    protected VaultOrient(String iClassName) {
        super(iClassName);
    }

    public String getValue() {
        return (String)this.field("value");
    }

    public void setValue(String value) {
        this.field("value", (Object)value);
    }

    public String toJSON(String iFormat) {
        return super.toJSON(iFormat);
    }

    public String getDecryptedValue() {
        return this.decryptedValue;
    }

    public String getDbEncryptedValue() {
        return this.dbEncryptedValue;
    }

    public String getContextEncryptedValue() {
        return this.contextEncryptedValue;
    }

    public void setDecryptedValue(String decryptedValue, boolean setEncryptedForContext) throws Exception {
        this.decryptedValue = decryptedValue;
        Key databaseKey = DatabaseEnvironment.getDatabaseKey();
        this.dbEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue, databaseKey);
        this.contextEncryptedValue = StringEncrypter.getEncrypter().encrypt(decryptedValue);
        if (setEncryptedForContext) {
            this.setValue(this.contextEncryptedValue);
        } else {
            this.setValue(this.dbEncryptedValue);
        }
    }

    public Map<String, Object> getAdditionalProperties() {
        return null;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
    }

    public Object getAdditionalProperty(String key) {
        return null;
    }

    public void setAdditionalProperty(String key, Object value) {
    }
}

