/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.queries.json.JsonQuery;
import org.gcube.informationsystem.resourceregistry.queries.json.base.JsonQueryERElement;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryFacet;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryIsRelatedTo;
import org.gcube.informationsystem.resourceregistry.types.CachedType;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonQuery {
    private static Logger logger = LoggerFactory.getLogger(JsonQuery.class);
    private static final Integer UNBOUNDED_LIMIT = -1;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected JsonNode jsonQuery;
    protected JsonQueryERElement entryPoint;
    protected ODatabaseDocument oDatabaseDocument;

    public void setJsonQuery(JsonNode jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    public void setJsonQuery(String jsonQuery) throws InvalidQueryException {
        try {
            this.jsonQuery = this.objectMapper.readTree(jsonQuery);
        }
        catch (IOException e) {
            throw new InvalidQueryException((Throwable)e);
        }
    }

    public static JsonQueryERElement getJsonQueryERElement(JsonNode jsonQuery) throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        String type = jsonQuery.get("@class").asText();
        AccessType accessType = TypesCache.getInstance().getCachedType(type).getAccessType();
        JsonQueryResource jsonQueryERElement = null;
        switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
            case 1: {
                jsonQueryERElement = new JsonQueryResource(jsonQuery);
                jsonQueryERElement.setDirection(Direction.OUT);
                break;
            }
            case 2: {
                jsonQueryERElement = new JsonQueryFacet(jsonQuery);
                break;
            }
            case 3: {
                jsonQueryERElement = new JsonQueryIsRelatedTo(jsonQuery);
                break;
            }
            case 4: {
                jsonQueryERElement = new JsonQueryConsistsOf(jsonQuery);
                break;
            }
            default: {
                throw new InvalidQueryException(String.format("%s is not querable", type.toString()));
            }
        }
        return jsonQueryERElement;
    }

    public StringBuffer createQuery() throws SchemaException, InvalidQueryException, ResourceRegistryException {
        this.entryPoint = JsonQuery.getJsonQueryERElement((JsonNode)this.jsonQuery);
        this.entryPoint.setEntryPoint(true);
        return this.entryPoint.analize(new StringBuffer());
    }

    public String query() throws InvalidQueryException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        this.oDatabaseDocument = null;
        try {
            SecurityContext securityContext = ContextUtility.getCurrentSecurityContext();
            this.oDatabaseDocument = securityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            this.oDatabaseDocument.begin();
            StringBuffer stringBuffer = this.createQuery();
            stringBuffer.append(" limit :limit");
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("limit", UNBOUNDED_LIMIT);
            String query = stringBuffer.toString();
            logger.trace("Going to execute the following query:\n{} \n from the JSONQuery\n{}", (Object)query, (Object)this.objectMapper.writeValueAsString((Object)this.jsonQuery));
            OResultSet resultSet = this.oDatabaseDocument.query(query, map);
            ArrayNode arrayNode = this.objectMapper.createArrayNode();
            while (resultSet.hasNext()) {
                OResult oResult = resultSet.next();
                OElement element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
                try {
                    JsonNode jsonNodeResult = null;
                    ElementManagement erManagement = ElementManagementUtility.getERManagement((SecurityContext)securityContext, (ODatabaseDocument)this.oDatabaseDocument, (OElement)element);
                    String requestedType = this.entryPoint.getType();
                    String gotType = erManagement.getTypeName();
                    if (requestedType.compareTo(gotType) == 0) {
                        jsonNodeResult = erManagement.serializeAsJsonNode();
                        arrayNode.add(jsonNodeResult);
                        continue;
                    }
                    CachedType cachedType = TypesCache.getInstance().getCachedType(gotType);
                    if (!cachedType.getSuperTypes().contains(requestedType)) continue;
                    jsonNodeResult = erManagement.serializeAsJsonNode();
                    arrayNode.add(jsonNodeResult);
                }
                catch (ResourceRegistryException e) {
                    logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)element.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                }
            }
            String string = this.objectMapper.writeValueAsString((Object)arrayNode);
            return string;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }
}

