/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.relations;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.types.reference.entities.ResourceType;

public class IsRelatedToManagement
extends RelationManagement<ResourceManagement, ResourceType> {
    public static final PropagationConstraint DEFAULT_IS_RELATED_TO_PC = new PropagationConstraintImpl();

    public IsRelatedToManagement() {
        super(AccessType.IS_RELATED_TO, Resource.class, DEFAULT_IS_RELATED_TO_PC);
    }

    protected IsRelatedToNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new IsRelatedToNotFoundException(e.getMessage(), e.getCause());
    }

    public IsRelatedToAvailableInAnotherContextException getSpecificAvailableInAnotherContextException(String message) {
        return new IsRelatedToAvailableInAnotherContextException(message);
    }

    protected IsRelatedToAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new IsRelatedToAlreadyPresentException(message);
    }

    protected ResourceManagement newTargetEntityManagement() throws ResourceRegistryException {
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setWorkingContext(this.getWorkingContext());
        resourceManagement.setODatabaseDocument(this.oDatabaseDocument);
        return resourceManagement;
    }

    protected JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfAsJsonNode();
        try {
            if (this.includeSource) {
                EntityElementManagement sourceEntityManagement = this.getSourceEntityManagement();
                ((ObjectNode)relation).replace("source", sourceEntityManagement.serializeSelfAsJsonNode());
            }
            if (this.includeTarget) {
                EntityElementManagement targetEntityManagement = this.getTargetEntityManagement();
                ((ObjectNode)relation).replace("target", targetEntityManagement.serializeSelfAsJsonNode());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
        super.sanityCheck();
    }

    static {
        DEFAULT_IS_RELATED_TO_PC.setDeleteConstraint(PropagationConstraint.DeleteConstraint.keep);
        DEFAULT_IS_RELATED_TO_PC.setRemoveConstraint(PropagationConstraint.RemoveConstraint.keep);
        DEFAULT_IS_RELATED_TO_PC.setAddConstraint(PropagationConstraint.AddConstraint.unpropagate);
    }
}

