/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sharing")
public class SharingManager {
    private static Logger logger = LoggerFactory.getLogger(SharingManager.class);

    public SharingManager() {
        ContextUtility.getHierarchicalMode().set(false);
        ContextUtility.getIncludeInstanceContexts().set(false);
    }

    protected String serializeAffectedInstaces(ObjectMapper objectMapper, Map<UUID, JsonNode> affectedInstances) throws ResourceRegistryException {
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (JsonNode jsonNode : affectedInstances.values()) {
            arrayNode.add(jsonNode);
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String addRemoveNoPropagationConstraint(@PathParam(value="CONTEXT_UUID") String contextId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @QueryParam(value="forceAddToContext") @DefaultValue(value="false") Boolean forceAddToContext, String body) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            StringBuffer calledMethod = new StringBuffer();
            if (dryRun == null) {
                dryRun = false;
            }
            if (dryRun.booleanValue()) {
                calledMethod.append("dryRun");
            }
            if (operation == SharingPath.SharingOperation.ADD) {
                logger.info("Requested {} {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", body, "Context", contextId});
                calledMethod.append("AddToContext");
            } else {
                logger.info("Requested {} {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", body, "Context", contextId});
                calledMethod.append("RemoveFromContext");
            }
            calledMethod.append("NoPropagationConstraint");
            CalledMethodProvider.instance.set(calledMethod.toString());
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = (ArrayNode)objectMapper.readTree(body);
            HashMap<UUID, JsonNode> expectedInstances = new HashMap<UUID, JsonNode>();
            for (JsonNode node : arrayNode) {
                String type = node.get("@class").asText();
                String instanceId = node.get("header").get("uuid").asText();
                UUID uuid = UUID.fromString(instanceId);
                expectedInstances.put(uuid, node);
            }
            UUID contextUUID = UUID.fromString(contextId);
            Map affectedInstances = null;
            if (operation == SharingPath.SharingOperation.ADD) {
                // empty if block
            }
            return this.serializeAffectedInstaces(objectMapper, affectedInstances);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @POST
    @Path(value="/contexts/{CONTEXT_UUID}/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String addRemove(@PathParam(value="CONTEXT_UUID") String contextId, @PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, @QueryParam(value="forceAddToContext") @DefaultValue(value="false") Boolean forceAddToContext) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        StringBuffer calledMethod = new StringBuffer();
        if (dryRun == null) {
            dryRun = false;
        }
        if (dryRun.booleanValue()) {
            calledMethod.append("dryRun");
        }
        if (operation == SharingPath.SharingOperation.ADD) {
            logger.info("Requested {} {} with UUID {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", type, instanceId, "Context", contextId});
            calledMethod.append("AddToContext");
        } else {
            logger.info("Requested {} {} with UUID {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", type, instanceId, "Context", contextId});
            calledMethod.append("RemoveFromContext");
        }
        CalledMethodProvider.instance.set(calledMethod.toString());
        ElementManagement elementManagement = ElementManagementUtility.getERManagement((String)type);
        elementManagement.setUUID(UUID.fromString(instanceId));
        elementManagement.setDryRun(dryRun.booleanValue());
        UUID contextUUID = UUID.fromString(contextId);
        if (operation == SharingPath.SharingOperation.ADD) {
            ((ERManagement)elementManagement).setForceAddToContext(forceAddToContext);
            ((ERManagement)elementManagement).addToContext(contextUUID);
        } else {
            ((ERManagement)elementManagement).removeFromContext(contextUUID);
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return this.serializeAffectedInstaces(objectMapper, elementManagement.getAffectedInstances());
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }
}

