/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types.relations;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.TypeSecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.EntityTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.ResourceTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;

public abstract class RelationTypeDefinitionManagement<T extends EntityTypeDefinitionManagement<TT>, TT extends EntityType>
extends RelationElementManagement<ResourceTypeDefinitionManagement, T, ResourceType, TT> {
    protected String name;

    public RelationTypeDefinitionManagement(Class<TT> clz) {
        super(AccessType.RELATION_TYPE, ResourceType.class, clz);
        this.typeName = "RelationType";
    }

    public RelationTypeDefinitionManagement(SecurityContext securityContext, ODatabaseDocument oDatabaseDocument, Class<TT> clz) throws ResourceRegistryException {
        this(clz);
        this.oDatabaseDocument = oDatabaseDocument;
        this.setWorkingContext(securityContext);
    }

    public Map<UUID, JsonNode> getAffectedInstances() {
        throw new UnsupportedOperationException();
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = TypeSecurityContext.getInstance();
        }
        return this.workingContext;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OEdge)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected OEdge reallyCreate() throws ResourceRegistryException {
        this.logger.debug("Going to create {} for {}", (Object)"RelationType", (Object)this.getName());
        if (this.sourceEntityManagement == null) {
            if (!this.jsonNode.has("source")) {
                throw new ResourceRegistryException("Error while creating relation. No source definition found");
            }
            this.sourceEntityManagement = this.newSourceEntityManagement();
            ((ResourceTypeDefinitionManagement)this.sourceEntityManagement).setJsonNode(this.jsonNode.get("source"));
        }
        if (this.targetEntityManagement == null) {
            if (!this.jsonNode.has("target")) {
                throw new ResourceRegistryException("Error while creating " + this.typeName + ". No target definition found");
            }
            this.targetEntityManagement = this.newTargetEntityManagement();
            ((EntityTypeDefinitionManagement)this.targetEntityManagement).setJsonNode(this.jsonNode.get("target"));
        }
        OVertex source = ((ResourceTypeDefinitionManagement)this.getSourceEntityManagement()).getElement();
        OVertex target = ((EntityTypeDefinitionManagement)this.getTargetEntityManagement()).getElement();
        this.logger.trace("Creating {} beetween {} -> {}", new Object[]{this.typeName, source.toString(), target.toString()});
        this.element = this.oDatabaseDocument.newEdge(source, target, this.typeName);
        this.updateProperties(this.oClass, this.element, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        return (OEdge)this.element;
    }

    protected OEdge reallyUpdate() throws NotFoundException, ResourceRegistryException {
        this.logger.debug("Going to update {} for {}", (Object)"RelationType", (Object)this.getName());
        OEdge relationTypeDefinition = this.getElement();
        relationTypeDefinition = (OEdge)this.updateProperties(this.oClass, (OElement)relationTypeDefinition, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        return relationTypeDefinition;
    }

    protected void reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} for {}", (Object)"RelationType", (Object)this.getName());
        this.getElement().delete();
    }

    public OEdge getElement() throws NotFoundException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            ((OEdge)this.element).reload();
        }
        return (OEdge)this.element;
    }

    public OEdge retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.getName() == null) {
                throw new NotFoundException("null name does not allow to retrieve the Element");
            }
            String select = "SELECT FROM " + this.typeName + " WHERE " + "name" + " = \"" + this.getName() + "\"";
            OResultSet resultSet = this.oDatabaseDocument.query(select, new HashMap());
            if (resultSet == null || !resultSet.hasNext()) {
                String error = String.format("No %s with name %s was found", this.typeName, this.getName());
                this.logger.info(error);
                throw new NotFoundException(error);
            }
            OResult oResult = resultSet.next();
            OEdge element = (OEdge)ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
            this.logger.trace("{} with id {} is : {}", new Object[]{this.typeName, this.getName(), Utility.toJsonString((OElement)element, (boolean)true)});
            if (resultSet.hasNext()) {
                throw new ResourceRegistryException("Found more than one " + this.typeName + " with name " + this.getName() + ". This is a fatal error please contact Admnistrator");
            }
            return element;
        }
        catch (NotFoundException e) {
            throw this.getSpecificNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected NotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new SchemaNotFoundException(e.getMessage(), e.getCause());
    }

    protected AlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new SchemaAlreadyPresentException(message);
    }

    protected ResourceTypeDefinitionManagement newSourceEntityManagement() throws ResourceRegistryException {
        ResourceTypeDefinitionManagement rtdm = new ResourceTypeDefinitionManagement();
        rtdm.setWorkingContext(this.getWorkingContext());
        rtdm.setODatabaseDocument(this.oDatabaseDocument);
        return rtdm;
    }

    protected void checksourceAndTargetEntityCompliancy() throws NotFoundException, AvailableInAnotherContextException, SchemaViolationException, ResourceRegistryException {
    }
}

