/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.security;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.ContextSecurityContext;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextSecurityContext
extends SecurityContext {
    private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
    private static final String CONTEXT_SECURITY_CONTEXT = "ffffffff-ffff-ffff-ffff-ffffffffffff";
    private static final UUID CONTEXT_SECURITY_CONTEXT_UUID = UUID.fromString(CONTEXT_SECURITY_CONTEXT);
    private static ContextSecurityContext instance;

    public static ContextSecurityContext getInstance() throws ResourceRegistryException {
        if (instance == null) {
            instance = new ContextSecurityContext();
            ContextUtility contextUtility = ContextUtility.getInstance();
            contextUtility.addSecurityContext(CONTEXT_SECURITY_CONTEXT, (SecurityContext)instance);
        }
        return instance;
    }

    private ContextSecurityContext() throws ResourceRegistryException {
        super(CONTEXT_SECURITY_CONTEXT_UUID, false);
    }

    protected ORole addExtraRules(ORole role, SecurityContext.PermissionMode permissionMode) {
        logger.trace("Adding extra rules for {}", (Object)role.getName());
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$contexts$security$SecurityContext$PermissionMode[permissionMode.ordinal()]) {
            case 1: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
                break;
            }
            case 2: {
                role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_READ);
                role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
                break;
            }
        }
        return role;
    }
}

