package org.gcube.informationsystem.resourceregistry.queries.operators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public enum QueryLogicalOperator {

	AND("$and", " AND ", "true if both the conditions are true"),
	OR("$or", " OR ", "true if at least one of the condition is true"),
	NOT("$not", " NOT ", "true if the condition is false.");
	
	protected final String operator;
	protected final String logicalOperator;
	protected final String description;
	
	private QueryLogicalOperator(String operator, String logicalOperator, String description) {
		this.operator = operator;
		this.logicalOperator = logicalOperator;
		this.description = description;
	}
	
	public String getOperator() {
		return operator;
	}
	
	public String getLogicalOperator() {
		return logicalOperator;
	}

	public String getDescription() {
		return description;
	}

	private static Set<String> operators;
	private static Map<String,QueryLogicalOperator> operatorByKey;
	
	static {
		QueryLogicalOperator.operators = new HashSet<>();
		QueryLogicalOperator.operatorByKey = new HashMap<>();
		
		for(QueryLogicalOperator queryLogicalOperator : QueryLogicalOperator.values()) {
			QueryLogicalOperator.operators.add(queryLogicalOperator.getOperator());
			QueryLogicalOperator.operatorByKey.put(queryLogicalOperator.getOperator(), queryLogicalOperator);
		}
	}
	
	public static Set<String> getOperators() {
		return QueryLogicalOperator.operators;
	}
	
	public static QueryLogicalOperator getQueryLogicalOperator(String key) {
		return operatorByKey.get(key);
	}
}
