/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityTypeDefinitionManagement<E extends EntityType>
extends EntityElementManagement<E> {
    private static Logger logger = LoggerFactory.getLogger(EntityTypeDefinitionManagement.class);
    protected String name;

    protected EntityTypeDefinitionManagement(Class<E> clz) {
        super(AccessType.ENTITY_TYPE);
        this.elementType = TypeMapper.getType(clz);
    }

    protected EntityTypeDefinitionManagement(SecurityContext securityContext, ODatabaseDocument oDatabaseDocument, Class<E> clz) throws ResourceRegistryException {
        this(clz);
        this.oDatabaseDocument = oDatabaseDocument;
        this.setWorkingContext(securityContext);
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.SCHEMA_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OVertex)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeSelfOnly();
    }

    protected OVertex reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        logger.debug("Going to create {} for {}", (Object)this.elementType, (Object)this.getName());
        return this.createVertex();
    }

    protected OVertex reallyUpdate() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to update {} for {}", (Object)this.elementType, (Object)this.getName());
        OVertex entityTypeDefinition = this.getElement();
        entityTypeDefinition = (OVertex)ElementManagement.updateProperties((OClass)this.oClass, (OElement)entityTypeDefinition, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        return entityTypeDefinition;
    }

    protected boolean reallyDelete() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to remove {} for {}", (Object)this.elementType, (Object)this.getName());
        this.getElement().delete();
        return true;
    }

    public OVertex getElement() throws NotFoundException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            ((OVertex)this.element).reload();
        }
        return (OVertex)this.element;
    }

    public OVertex retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.getName() == null) {
                throw new NotFoundException("null name does not allow to retrieve the Element");
            }
            String select = "SELECT FROM " + this.elementType + " WHERE " + "name" + " = \"" + this.getName() + "\"";
            OResultSet resultSet = this.oDatabaseDocument.query(select, new HashMap());
            if (resultSet == null || !resultSet.hasNext()) {
                String error = String.format("No %s with name %s was found", this.elementType, this.getName());
                logger.info(error);
                throw new NotFoundException(error);
            }
            OResult oResult = resultSet.next();
            OVertex element = (OVertex)ElementManagement.getElementFromOptional((Optional)oResult.getElement());
            logger.trace("{} with id {} is : {}", new Object[]{this.elementType, this.getName(), Utility.toJsonString((OElement)element, (boolean)true)});
            if (resultSet.hasNext()) {
                throw new ResourceRegistryException("Found more than one " + this.elementType + " with name " + this.getName() + ". This is a fatal error please contact Admnistrator");
            }
            return element;
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected OVertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        logger.trace("Going to create {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode});
        try {
            this.element = this.oDatabaseDocument.newVertex(this.elementType);
            ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            logger.info("Created {} is {}", (Object)OVertex.class.getSimpleName(), (Object)Utility.toJsonString((OElement)this.element, (boolean)true));
            return (OVertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, e.getCause());
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected NotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new SchemaNotFoundException(e.getMessage(), e.getCause());
    }

    protected AlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new SchemaAlreadyPresentException(message);
    }

    protected AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        throw new UnsupportedOperationException();
    }
}

