/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.NullNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.relations.IsParentOfManagement;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.utils.ElementMapper;
import org.gcube.informationsystem.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextManagement
extends EntityElementManagement<Context> {
    private static Logger logger = LoggerFactory.getLogger(ContextManagement.class);
    protected String name;
    protected ContextCacheRenewal contextCacheRenewal = new /* Unavailable Anonymous Inner Class!! */;

    private void init() {
        this.ignoreStartWithKeys.add("parent");
        this.ignoreStartWithKeys.add("children");
        this.elementType = "Context";
    }

    public ContextManagement() {
        super(AccessType.CONTEXT);
        this.init();
        ContextCache contextCache = ContextCache.getInstance();
        contextCache.setContextCacheRenewal(this.contextCacheRenewal);
    }

    public ContextManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.getWorkingContext();
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OVertex)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.CONTEXT_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    protected ContextNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new ContextNotFoundException(e.getMessage(), e.getCause());
    }

    protected EntityAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        return new EntityAvailableInAnotherContextException(message);
    }

    protected ContextAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new ContextAlreadyPresentException(message);
    }

    protected void checkContext(ContextManagement parentContext) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        if (parentContext != null) {
            String parentId = ((OVertex)parentContext.getElement()).getIdentity().toString();
            String select = "SELECT FROM (TRAVERSE out(IsParentOf) FROM " + parentId + " MAXDEPTH 1) WHERE " + "name" + "=\"" + this.getName() + "\" AND " + "header" + "." + "uuid" + "<>\"" + parentContext.uuid + "\"";
            logger.trace(select);
            StringBuilder message = new StringBuilder();
            message.append("A context with name (");
            message.append(this.getName());
            message.append(") has been already created as child of ");
            message.append(parentContext.serializeSelfOnly().toString());
            logger.trace("Checking if {} -> {}", (Object)message, (Object)select);
            OResultSet resultSet = this.oDatabaseDocument.command(select, new HashMap());
            if (resultSet != null && resultSet.hasNext()) {
                throw new ContextAlreadyPresentException(message.toString());
            }
        } else {
            String select = "SELECT FROM Context WHERE name = \"" + this.getName() + "\" AND in(\"" + "IsParentOf" + "\").size() = 0";
            OResultSet resultSet = this.oDatabaseDocument.command(select, new HashMap());
            if (resultSet != null && resultSet.hasNext()) {
                throw new ContextAlreadyPresentException("A root context with the same name (" + this.getName() + ") already exist");
            }
        }
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        JsonNode context = this.serializeSelfOnly();
        int count = 0;
        Iterable parents = ((OVertex)this.getElement()).getEdges(ODirection.IN);
        for (OEdge edge : parents) {
            if (++count > 1) {
                throw new ContextException("A Context can not have more than one parent");
            }
            try {
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
                isParentOfManagement.setElement((OElement)edge);
                JsonNode isParentOf = isParentOfManagement.serializeAsJson(true, false);
                if (isParentOf == null) continue;
                ((ObjectNode)context).replace("parent", isParentOf);
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ContextException("");
            }
        }
        Iterable childrenEdges = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        for (OEdge edge : childrenEdges) {
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
            isParentOfManagement.setElement((OElement)edge);
            try {
                JsonNode isParentOf = isParentOfManagement.serializeAsJson();
                context = ContextManagement.addRelation((JsonNode)context, (JsonNode)isParentOf, (String)"children");
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return context;
    }

    protected OVertex reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        SecurityContext securityContext = null;
        SecurityContext parentSecurityContext = null;
        try {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
                JsonNode parentJsonNode = isParentOfJsonNode.get("source");
                ContextManagement parentContextManagement = new ContextManagement(this.oDatabaseDocument);
                parentContextManagement.setJsonNode(parentJsonNode);
                UUID parentUUID = parentContextManagement.uuid;
                parentSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(parentUUID);
                this.checkContext(parentContextManagement);
                if (this.uuid == null) {
                    this.uuid = UUID.randomUUID();
                }
                this.createVertex();
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
                isParentOfManagement.setJsonNode(isParentOfJsonNode);
                isParentOfManagement.setSourceEntityManagement((EntityElementManagement)parentContextManagement);
                isParentOfManagement.setTargetEntityManagement((EntityElementManagement)this);
                isParentOfManagement.internalCreate();
            } else {
                this.checkContext(null);
                this.createVertex();
            }
            securityContext = new SecurityContext(this.uuid);
            securityContext.setParentSecurityContext(parentSecurityContext);
            securityContext.create(this.oDatabaseDocument);
            ContextUtility.getInstance().addSecurityContext(securityContext);
            return (OVertex)this.getElement();
        }
        catch (Exception e) {
            this.oDatabaseDocument.rollback();
            if (securityContext != null) {
                securityContext.delete(this.oDatabaseDocument);
                if (parentSecurityContext != null && securityContext != null) {
                    parentSecurityContext.getChildren().remove(securityContext);
                }
                ContextCache.getInstance().cleanCache();
            }
            throw e;
        }
    }

    protected OVertex reallyUpdate() throws NotFoundException, ResourceRegistryException {
        boolean parentChanged = false;
        boolean nameChanged = false;
        OVertex parent = null;
        boolean found = false;
        Iterable iterable = ((OVertex)this.getElement()).getVertices(ODirection.IN, new String[]{"IsParentOf"});
        for (OVertex p : iterable) {
            if (found) {
                String message = String.format("{} has more than one parent. {}", "Context", "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(message.toString());
            }
            parent = p;
            found = true;
        }
        ContextManagement actualParentContextManagement = null;
        if (parent != null) {
            actualParentContextManagement = new ContextManagement(this.oDatabaseDocument);
            actualParentContextManagement.setElement((OElement)parent);
        }
        ContextManagement newParentContextManagement = actualParentContextManagement;
        JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
        JsonNode parentContextJsonNode = null;
        if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
            parentContextJsonNode = isParentOfJsonNode.get("source");
        }
        if (parentContextJsonNode != null && !(parentContextJsonNode instanceof NullNode)) {
            UUID parentUUID = Utility.getUUIDFromJsonNode((JsonNode)parentContextJsonNode);
            if (actualParentContextManagement != null) {
                if (parentUUID.compareTo(actualParentContextManagement.uuid) != 0) {
                    parentChanged = true;
                }
            } else {
                parentChanged = true;
            }
            if (parentChanged) {
                newParentContextManagement = new ContextManagement(this.oDatabaseDocument);
                newParentContextManagement.setJsonNode(parentContextJsonNode);
            }
        } else if (actualParentContextManagement != null) {
            parentChanged = true;
            newParentContextManagement = null;
        }
        String oldName = (String)((OVertex)this.getElement()).getProperty("name");
        String newName = this.jsonNode.get("name").asText();
        if (oldName.compareTo(newName) != 0) {
            nameChanged = true;
            this.name = newName;
        }
        if (parentChanged || nameChanged) {
            this.checkContext(newParentContextManagement);
        }
        if (parentChanged) {
            this.move(newParentContextManagement, false);
        }
        this.element = (OVertex)ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.getElement(), (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        ContextCache.getInstance().cleanCache();
        return (OVertex)this.element;
    }

    private void move(ContextManagement newParentContextManagement, boolean check) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        if (check) {
            this.checkContext(newParentContextManagement);
        }
        SecurityContext newParentSecurityContext = null;
        Iterable edges = ((OVertex)this.getElement()).getEdges(ODirection.IN, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            Iterator edgeIterator = edges.iterator();
            OEdge edge = (OEdge)edgeIterator.next();
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement();
            isParentOfManagement.setElement((OElement)edge);
            isParentOfManagement.internalDelete();
            if (edgeIterator.hasNext()) {
                throw new ContextException("Seems that the Context has more than one Parent. This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        if (newParentContextManagement != null) {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
            isParentOfManagement.setJsonNode(isParentOfJsonNode);
            isParentOfManagement.setSourceEntityManagement((EntityElementManagement)newParentContextManagement);
            isParentOfManagement.setTargetEntityManagement((EntityElementManagement)this);
            isParentOfManagement.internalCreate();
            newParentSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(newParentContextManagement.uuid);
        }
        SecurityContext thisSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(this.uuid);
        thisSecurityContext.changeParentSecurityContext(newParentSecurityContext, this.oDatabaseDocument);
    }

    protected boolean reallyDelete() throws NotFoundException, ResourceRegistryException {
        Iterable iterable = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            throw new ContextException("Cannot remove a Context having children");
        }
        ((OVertex)this.element).delete();
        ContextUtility contextUtility = ContextUtility.getInstance();
        SecurityContext securityContext = contextUtility.getSecurityContextByUUID(this.uuid);
        securityContext.delete(this.oDatabaseDocument);
        ContextCache.getInstance().cleanCache();
        return true;
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.elementType, polymorphic);
        for (ODocument vertex : iterable) {
            ContextManagement contextManagement = new ContextManagement();
            contextManagement.setElement((OElement)((OVertex)vertex));
            try {
                JsonNode jsonObject = contextManagement.serializeAsJson();
                arrayNode.add(jsonObject);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    public String allFromServer(boolean polymorphic) throws ResourceRegistryException {
        return super.all(polymorphic);
    }

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            ContextCache contextCache = ContextCache.getInstance();
            return ElementMapper.marshal((List)contextCache.getContexts());
        }
        catch (JsonProcessingException | ResourceRegistryException e) {
            return this.allFromServer(polymorphic);
        }
    }

    public String readFromServer() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        return super.read();
    }

    public String read() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            ContextCache contextCache = ContextCache.getInstance();
            return ElementMapper.marshal((Element)contextCache.getContextByUUID(this.uuid));
        }
        catch (JsonProcessingException | ResourceRegistryException e) {
            return this.readFromServer();
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

