/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.types.relations;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.EntityTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.types.entities.ResourceTypeDefinitionManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;

public abstract class RelationTypeDefinitionManagement<T extends EntityTypeDefinitionManagement<TT>, TT extends EntityType>
extends RelationElementManagement<ResourceTypeDefinitionManagement, T> {
    protected String name;

    public RelationTypeDefinitionManagement(Class<TT> clz) {
        super(AccessType.RELATION_TYPE, ResourceType.class, clz);
        this.elementType = "RelationType";
    }

    public RelationTypeDefinitionManagement(SecurityContext securityContext, ODatabaseDocument oDatabaseDocument, Class<TT> clz) throws ResourceRegistryException {
        this(clz);
        this.oDatabaseDocument = oDatabaseDocument;
        this.setWorkingContext(securityContext);
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.SCHEMA_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OEdge)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected OEdge reallyCreate() throws ResourceRegistryException {
        this.logger.debug("Going to create {} for {}", (Object)"RelationType", (Object)this.getName());
        if (this.sourceEntityManagement == null) {
            if (!this.jsonNode.has("source")) {
                throw new ResourceRegistryException("Error while creating relation. No source definition found");
            }
            this.sourceEntityManagement = this.newSourceEntityManagement();
            ((ResourceTypeDefinitionManagement)this.sourceEntityManagement).setJsonNode(this.jsonNode.get("source"));
        }
        if (this.targetEntityManagement == null) {
            if (!this.jsonNode.has("target")) {
                throw new ResourceRegistryException("Error while creating " + this.elementType + ". No target definition found");
            }
            this.targetEntityManagement = this.newTargetEntityManagement();
            ((EntityTypeDefinitionManagement)this.targetEntityManagement).setJsonNode(this.jsonNode.get("target"));
        }
        this.logger.trace("Creating {} beetween {} -> {}", new Object[]{this.elementType, ((ResourceTypeDefinitionManagement)this.getSourceEntityManagement()).serialize(), ((EntityTypeDefinitionManagement)this.getTargetEntityManagement()).serialize()});
        OVertex source = ((ResourceTypeDefinitionManagement)this.getSourceEntityManagement()).getElement();
        OVertex target = ((EntityTypeDefinitionManagement)this.getTargetEntityManagement()).getElement();
        this.element = this.oDatabaseDocument.newEdge(source, target, this.elementType);
        ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        return (OEdge)this.element;
    }

    protected OEdge reallyUpdate() throws NotFoundException, ResourceRegistryException {
        this.logger.debug("Going to update {} for {}", (Object)"RelationType", (Object)this.getName());
        OEdge relationTypeDefinition = this.getElement();
        relationTypeDefinition = (OEdge)ElementManagement.updateProperties((OClass)this.oClass, (OElement)relationTypeDefinition, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        return relationTypeDefinition;
    }

    protected boolean reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} for {}", (Object)"RelationType", (Object)this.getName());
        this.getElement().delete();
        return true;
    }

    public OEdge getElement() throws NotFoundException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                throw e;
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            ((OEdge)this.element).reload();
        }
        return (OEdge)this.element;
    }

    public OEdge retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.getName() == null) {
                throw new NotFoundException("null name does not allow to retrieve the Element");
            }
            String select = "SELECT FROM " + this.elementType + " WHERE " + "name" + " = \"" + this.getName() + "\"";
            OResultSet resultSet = this.oDatabaseDocument.query(select, new HashMap());
            if (resultSet == null || !resultSet.hasNext()) {
                String error = String.format("No %s with name %s was found", this.elementType, this.getName());
                this.logger.info(error);
                throw new NotFoundException(error);
            }
            OResult oResult = resultSet.next();
            OEdge element = (OEdge)ElementManagement.getElementFromOptional((Optional)oResult.getElement());
            this.logger.trace("{} with id {} is : {}", new Object[]{this.elementType, this.getName(), Utility.toJsonString((OElement)element, (boolean)true)});
            if (resultSet.hasNext()) {
                throw new ResourceRegistryException("Found more than one " + this.elementType + " with name " + this.getName() + ". This is a fatal error please contact Admnistrator");
            }
            return element;
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        throw new UnsupportedOperationException();
    }

    protected NotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new SchemaNotFoundException(e.getMessage(), e.getCause());
    }

    protected AlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new SchemaAlreadyPresentException(message);
    }

    protected AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        throw new UnsupportedOperationException();
    }

    protected ResourceTypeDefinitionManagement newSourceEntityManagement() throws ResourceRegistryException {
        return new ResourceTypeDefinitionManagement(this.getWorkingContext(), this.oDatabaseDocument);
    }
}

