/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.ArrayList;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.rest.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sharing")
public class SharingManagement {
    private static Logger logger = LoggerFactory.getLogger(SharingManagement.class);

    protected void setCalledMethod(HTTPCall.HTTPMETHOD httpMethod, String type) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("sharing");
        list.add("contexts");
        list.add("{CONTEXT_UUID}");
        list.add(type);
        list.add("{UUID}");
        Access.setCalledMethod((HTTPCall.HTTPMETHOD)httpMethod, list, null);
    }

    @PUT
    @Path(value="contexts/{CONTEXT_UUID}/{TYPE_NAME}/{UUID}")
    public boolean add(@PathParam(value="CONTEXT_UUID") String contextId, @PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String id) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to add {} with UUID {} to {} with UUID {}", new Object[]{type, id, "Context", contextId});
        this.setCalledMethod(HTTPCall.HTTPMETHOD.PUT, type);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        erManagement.setUUID(uuid);
        UUID contextUUID = null;
        try {
            contextUUID = UUID.fromString(contextId);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return erManagement.addToContext(contextUUID);
    }

    @DELETE
    @Path(value="contexts/{CONTEXT_UUID}/{TYPE_NAME}/{UUID}")
    public boolean remove(@PathParam(value="CONTEXT_UUID") String contextId, @PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String id) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to remove {} with UUID {} to {} with UUID {}", new Object[]{type, id, "Context", contextId});
        this.setCalledMethod(HTTPCall.HTTPMETHOD.DELETE, type);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        erManagement.setUUID(uuid);
        UUID contextUUID = null;
        try {
            contextUUID = UUID.fromString(contextId);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return erManagement.removeFromContext(contextUUID);
    }
}

