/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.util.ODateHelper;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.activation.UnsupportedDataTypeException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.ER;
import org.gcube.informationsystem.model.reference.embedded.Header;
import org.gcube.informationsystem.model.reference.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.EmbeddedMangement;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.utils.HeaderOrient;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ERManagement<ERType extends ER, El extends Element> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Logger staticLogger = LoggerFactory.getLogger(ERManagement.class);
    public final String AT = "@";
    public final String UNDERSCORE = "_";
    protected final Set<String> ignoreKeys;
    protected final Set<String> ignoreStartWithKeys;
    protected Class<El> elementClass;
    protected final AccessType accessType;
    protected OrientGraph orientGraph;
    protected UUID uuid;
    protected JsonNode jsonNode;
    protected OClass oClass;
    protected String elementType;
    protected El element;
    protected boolean reload;
    protected SecurityContext workingContext;

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getCurrentSecurityContext();
        }
        return this.workingContext;
    }

    public void setWorkingContext(SecurityContext workingContext) {
        this.workingContext = workingContext;
    }

    protected ERManagement(AccessType accessType) {
        this.accessType = accessType;
        this.ignoreKeys = new HashSet();
        this.ignoreStartWithKeys = new HashSet();
        this.ignoreStartWithKeys.add("@");
        this.ignoreStartWithKeys.add("_");
        this.reload = false;
    }

    public void setUUID(UUID uuid) throws ResourceRegistryException {
        this.uuid = uuid;
        if (this.jsonNode != null) {
            this.checkUUIDMatch();
        }
    }

    public void setJSON(JsonNode jsonNode) throws ResourceRegistryException {
        this.jsonNode = jsonNode;
        this.checkJSON();
    }

    public void setJSON(String jsonRepresentation) throws ResourceRegistryException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.jsonNode = mapper.readTree(jsonRepresentation);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        this.checkJSON();
    }

    protected OClass getOClass() throws SchemaException, ResourceRegistryException {
        if (this.oClass == null) {
            if (this.element != null) {
                OrientElement orientElement = (OrientElement)this.element;
                OMetadataDefault oMetadata = orientElement.getGraph().getRawGraph().getMetadata();
                OSchema oSchema = oMetadata.getSchema();
                String type = orientElement.getRecord().getClassName();
                this.oClass = oSchema.getClass(type);
            } else {
                this.oClass = SchemaManagementImpl.getTypeSchema((String)this.elementType, (AccessType)this.accessType);
            }
        }
        return this.oClass;
    }

    public void setElementType(String erType) throws ResourceRegistryException {
        if (this.elementType == null) {
            if (erType == null || erType.compareTo("") == 0) {
                erType = this.accessType.getName();
            }
            this.elementType = erType;
        } else if (this.elementType.compareTo(erType) != 0) {
            throw new ResourceRegistryException("Provided type " + erType + " does not match with the one already known " + this.accessType);
        }
        if (this.jsonNode != null) {
            this.checkERMatch();
        }
    }

    public String getElementType() {
        return this.elementType;
    }

    protected void checkJSON() throws ResourceRegistryException {
        if (this.uuid == null) {
            try {
                this.uuid = org.gcube.informationsystem.model.impl.utils.Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode);
            }
            catch (Exception exception) {}
        } else {
            this.checkUUIDMatch();
        }
        if (this.elementType == null) {
            this.elementType = ERManagement.getClassProperty((JsonNode)this.jsonNode);
            this.getOClass();
        } else {
            this.checkERMatch();
        }
    }

    protected void checkERMatch() throws ResourceRegistryException {
        String type;
        if (this.jsonNode != null && (type = ERManagement.getClassProperty((JsonNode)this.jsonNode)) != null && type.compareTo(this.elementType) != 0) {
            String error = String.format("Requested type does not match with json representation %s!=%s", this.elementType, type);
            this.logger.trace(error);
            throw new ResourceRegistryException(error);
        }
        this.getOClass();
    }

    protected void checkUUIDMatch() throws ResourceRegistryException {
        UUID resourceUUID;
        Header header = null;
        try {
            header = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)false);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        if (header != null && (resourceUUID = header.getUUID()).compareTo(this.uuid) != 0) {
            String error = String.format("UUID provided in header (%s) differs from the one (%s) used to identify the %s instance", resourceUUID.toString(), this.uuid.toString(), this.elementType);
            throw new ResourceRegistryException(error);
        }
    }

    public JSONObject serializeSelfOnly() throws ResourceRegistryException {
        try {
            return this.toJSONObject();
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String serialize() throws ResourceRegistryException;

    public abstract JSONObject serializeAsJson() throws ResourceRegistryException;

    protected abstract El reallyCreate() throws AlreadyPresentException, ResourceRegistryException;

    public El internalCreate() throws AlreadyPresentException, ResourceRegistryException {
        try {
            this.reallyCreate();
            Header entityHeader = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)true);
            if (entityHeader != null) {
                this.element.setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((Element)this.element, null);
            }
            this.getWorkingContext().addElement(this.element, this.orientGraph);
            ((OrientElement)this.element).save();
            return (El)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, (Throwable)e);
        }
    }

    protected abstract El reallyUpdate() throws NotFoundException, ResourceRegistryException;

    public El internalUpdate() throws NotFoundException, ResourceRegistryException {
        try {
            this.reallyUpdate();
            HeaderUtility.updateModifiedByAndLastUpdate((Element)this.element);
            ((OrientElement)this.element).save();
            return (El)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Updating " + this.elementType + " with " + this.jsonNode, (Throwable)e);
        }
    }

    public El internalCreateOrUdate() throws ResourceRegistryException {
        try {
            return (El)this.internalUpdate();
        }
        catch (NotFoundException e) {
            return (El)this.internalCreate();
        }
    }

    protected abstract boolean reallyDelete() throws NotFoundException, ResourceRegistryException;

    public boolean internalDelete() throws NotFoundException, ResourceRegistryException {
        return this.reallyDelete();
    }

    protected abstract boolean reallyAddToContext(SecurityContext var1) throws ContextException, ResourceRegistryException;

    public boolean internalAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        try {
            boolean ret = this.reallyAddToContext(targetSecurityContext);
            HeaderUtility.updateModifiedByAndLastUpdate((Element)this.element);
            ((OrientElement)this.element).save();
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Adding " + this.elementType + " to " + targetSecurityContext.toString(), e.getCause());
        }
    }

    protected abstract boolean reallyRemoveFromContext(SecurityContext var1) throws ContextException, ResourceRegistryException;

    public boolean internalRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        try {
            boolean ret = this.reallyRemoveFromContext(targetSecurityContext);
            HeaderUtility.updateModifiedByAndLastUpdate((Element)this.element);
            ((OrientElement)this.element).save();
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Removing " + this.elementType + " from " + targetSecurityContext.toString(), e.getCause());
        }
    }

    public void setElement(El element) throws ResourceRegistryException {
        if (element == null) {
            throw new ResourceRegistryException("Trying to set null " + this.elementClass.getSimpleName() + " in " + this);
        }
        this.element = element;
        this.uuid = HeaderUtility.getHeader(element).getUUID();
        this.elementType = ((OrientElement)element).getLabel();
    }

    protected abstract NotFoundException getSpecificElementNotFoundException(NotFoundException var1);

    protected abstract AvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String var1);

    protected abstract AlreadyPresentException getSpecificERAlreadyPresentException(String var1);

    public El getElement() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (NotFoundException e) {
                try {
                    this.retrieveElementFromAnyContext();
                    throw this.getSpecificERAvailableInAnotherContextException(this.elementType == null ? this.accessType.getName() : this.elementType + " with UUID " + this.uuid + " is available in another " + Context.class.getSimpleName());
                }
                catch (AvailableInAnotherContextException e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    throw e;
                }
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else if (this.reload) {
            ((OrientElement)this.element).reload();
        }
        return (El)this.element;
    }

    public El retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            if (this.uuid == null) {
                throw new NotFoundException("null UUID does not allow to retrieve the Element");
            }
            return (El)Utility.getElementByUUID((Graph)this.orientGraph, (String)(this.elementType == null ? this.accessType.getName() : this.elementType), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public El retrieveElementFromAnyContext() throws NotFoundException, ResourceRegistryException {
        try {
            return (El)Utility.getElementByUUIDAsAdmin((String)(this.elementType == null ? this.accessType.getName() : this.elementType), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (NotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String reallyGetAll(boolean var1) throws ResourceRegistryException;

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean exists() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.READER);
            this.getElement();
            boolean bl = true;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to find {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to find {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String createOrUpdate() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.WRITER);
            this.orientGraph.setAutoStartTx(false);
            this.orientGraph.begin();
            boolean update = false;
            try {
                this.getElement();
                update = true;
                this.element = this.internalUpdate();
            }
            catch (NotFoundException e) {
                this.element = this.internalCreate();
            }
            this.orientGraph.commit();
            if (update) {
                this.setReload(true);
            }
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String create() throws AlreadyPresentException, ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.WRITER);
            this.orientGraph.setAutoStartTx(false);
            this.orientGraph.begin();
            this.element = this.internalCreate();
            this.orientGraph.commit();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to create {}", (Object)this.accessType.getName());
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to create {}", (Object)this.accessType.getName(), (Object)e);
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String read() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.READER);
            this.getElement();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to read {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to read {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String update() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.WRITER);
            this.orientGraph.setAutoStartTx(false);
            this.orientGraph.begin();
            this.element = this.internalUpdate();
            this.orientGraph.commit();
            this.setReload(true);
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean delete() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        this.logger.debug("Going to delete {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
        try {
            this.orientGraph = ContextUtility.getAdminSecurityContext().getGraph(SecurityContext.PermissionMode.WRITER);
            this.orientGraph.setAutoStartTx(false);
            this.orientGraph.begin();
            boolean deleted = this.reallyDelete();
            if (deleted) {
                this.orientGraph.commit();
                this.logger.info("{} with UUID {} was successfully deleted.", (Object)this.accessType.getName(), (Object)this.uuid);
            } else {
                this.logger.info("{} with UUID {} was NOT deleted.", (Object)this.accessType.getName(), (Object)this.uuid);
                this.orientGraph.rollback();
            }
            boolean bl = deleted;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to delete {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to delete {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean addToContext(UUID contextUUID) throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.info("Going to add {} with UUID {} to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID});
        try {
            this.orientGraph = ContextUtility.getAdminSecurityContext().getGraph(SecurityContext.PermissionMode.WRITER);
            this.orientGraph.setAutoStartTx(false);
            this.orientGraph.begin();
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            boolean added = this.internalAddToContext(targetSecurityContext);
            this.orientGraph.commit();
            this.logger.info("{} with UUID {} successfully added to Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            boolean bl = added;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean removeFromContext(UUID contextUUID) throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {} from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
        try {
            this.orientGraph = ContextUtility.getAdminSecurityContext().getGraph(SecurityContext.PermissionMode.WRITER);
            this.orientGraph.setAutoStartTx(false);
            this.orientGraph.begin();
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            boolean removed = this.internalRemoveFromContext(targetSecurityContext);
            this.orientGraph.commit();
            this.logger.info("{} with UUID {} successfully removed from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            boolean bl = removed;
            return bl;
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.elementType, this.uuid, contextUUID, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    public static Object getObjectFromElement(JsonNode value) throws UnsupportedDataTypeException, ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return EmbeddedMangement.getEmbeddedType((JsonNode)value);
            }
            case 2: {
                throw new UnsupportedDataTypeException("List/Set support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public static Map<String, Object> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWith) throws JsonProcessingException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (ignoreStartWith == null) {
            ignoreStartWith = new HashSet<String>();
        }
        Iterator fields = jsonNode.fields();
        block2: while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWith) {
                if (!key.startsWith(prefix)) continue;
                continue block2;
            }
            JsonNode value = (JsonNode)entry.getValue();
            Object object = null;
            try {
                object = ERManagement.getObjectFromElement((JsonNode)value);
                if (object == null) continue;
                map.put(key, object);
            }
            catch (ResourceRegistryException e) {
                staticLogger.warn("An invalidy property has been provided. It will be ignored.");
            }
        }
        return map;
    }

    public static Element updateProperties(OClass oClass, Element element, JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWithKeys) throws ResourceRegistryException {
        Map properties;
        Set oldKeys = element.getPropertyKeys();
        if (element instanceof Vertex || element instanceof Edge) {
            try {
                properties = ERManagement.getPropertyMap((JsonNode)jsonNode, ignoreKeys, ignoreStartWithKeys);
            }
            catch (IOException e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else {
            String error = String.format("Error while updating %s properties", element.toString());
            throw new ResourceRegistryException(error);
        }
        oldKeys.removeAll(properties.keySet());
        for (String key : properties.keySet()) {
            try {
                Object object = properties.get(key);
                if (!oClass.existsProperty(key)) {
                    boolean set = false;
                    if (object instanceof ODocument) {
                        ODocument oDocument = (ODocument)object;
                        ((OrientElement)element).setProperty(key, (Object)oDocument, OType.EMBEDDED);
                        set = true;
                    }
                    if (set) continue;
                    element.setProperty(key, object);
                    continue;
                }
                element.setProperty(key, object);
            }
            catch (Exception e) {
                String error = String.format("Error while setting property %s : %s (%s)", key, properties.get(key).toString(), e.getMessage());
                staticLogger.error(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
        }
        block5: for (String key : oldKeys) {
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                continue block5;
            }
            element.removeProperty(key);
        }
        ((OrientElement)element).save();
        return element;
    }

    protected Object getPropertyForJson(String key, Object object) throws ResourceRegistryException {
        try {
            if (key.compareTo("header") == 0) {
                HeaderOrient headerOrient = HeaderUtility.getHeaderOrient((ODocument)((ODocument)object));
                JSONObject headerObject = new JSONObject(headerOrient.toJSON("class"));
                return headerObject;
            }
            if (this.ignoreKeys.contains(key)) {
                return null;
            }
            for (String prefix : this.ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                return null;
            }
            if (object instanceof ODocument) {
                String json = ((ODocument)object).toJSON("class");
                JSONObject jsonObject = new JSONObject(json);
                return jsonObject;
            }
            if (object instanceof Date) {
                OProperty oProperty = this.getOClass().getProperty(key);
                OType oType = oProperty.getType();
                DateFormat dateFormat = ODateHelper.getDateTimeFormatInstance();
                switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                    case 1: {
                        dateFormat = ODateHelper.getDateFormatInstance();
                        break;
                    }
                    case 2: {
                        dateFormat = ODateHelper.getDateTimeFormatInstance();
                        break;
                    }
                }
                return dateFormat.format((Date)object);
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                JSONArray jsonArray = new JSONArray();
                for (Object o : collection) {
                    Object obj = this.getPropertyForJson("PLACEHOLDER", o);
                    jsonArray.put(obj);
                }
                return jsonArray;
            }
            return object.toString();
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + key + "=" + object.toString() + " in " + this.getElement().toString(), (Throwable)e);
        }
    }

    protected Collection<String> getSuperclasses() throws SchemaException, ResourceRegistryException {
        Collection allSuperClasses = this.getOClass().getAllSuperClasses();
        HashSet<String> superClasses = new HashSet<String>();
        for (OClass oSuperClass : allSuperClasses) {
            String name = oSuperClass.getName();
            if (name.compareTo("v".toUpperCase()) == 0 || name.compareTo("e".toUpperCase()) == 0 || name.compareTo("ORestricted") == 0) continue;
            superClasses.add(name);
        }
        return superClasses;
    }

    public JSONObject toJSONObject() throws ResourceRegistryException {
        try {
            OrientElement orientElement = (OrientElement)this.getElement();
            Map properties = orientElement.getProperties();
            for (String key : orientElement.getPropertyKeys()) {
                Object object = properties.get(key);
                if ((object = this.getPropertyForJson(key, object)) != null) {
                    properties.put(key, object);
                    continue;
                }
                properties.remove(key);
            }
            JSONObject jsonObject = new JSONObject(properties);
            String type = orientElement.getRecord().getClassName();
            jsonObject.put("@class", (Object)type);
            Collection superClasses = this.getSuperclasses();
            JSONArray jsonArray = new JSONArray(superClasses);
            jsonObject.put("@superClasses", (Object)jsonArray);
            return jsonObject;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + this.getElement().toString(), (Throwable)e);
        }
    }
}

