/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.UUID;
import org.gcube.informationsystem.model.AccessType;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagement;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaContextManagement
implements SchemaManagement {
    private static Logger logger = LoggerFactory.getLogger(SchemaContextManagement.class);
    public static final String SCHEMA = "__SCHEMA";

    protected Vertex getVertex(OrientGraph orientGraph, String vertexType) throws Exception {
        Iterable iterable = orientGraph.getVerticesOfClass(vertexType, false);
        Iterator iterator = iterable.iterator();
        Vertex vertex = null;
        if (!iterator.hasNext()) {
            String error = String.format("%s is not a registered type", vertexType);
            logger.trace(error);
            throw new Exception(error);
        }
        vertex = (Vertex)iterator.next();
        if (iterator.hasNext()) {
            String error = String.format("More than one instance of %s found in Management Context. This MUST not happen. Please contact system administrator.", vertexType);
            logger.error(error);
            throw new Exception(error);
        }
        return vertex;
    }

    public String create(String json, AccessType baseType) throws SchemaException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        OrientGraph orientGraph = null;
        try {
            orientGraph = orientGraphFactory.getTx();
            ObjectMapper mapper = new ObjectMapper();
            TypeBinder.TypeDefinition typeDefinition = (TypeBinder.TypeDefinition)mapper.readValue(json, TypeBinder.TypeDefinition.class);
            if (Entity.class.isAssignableFrom(baseType.getTypeClass())) {
                OrientVertex orientVertex = orientGraph.addVertex((Object)("class:" + typeDefinition.getName()));
                orientVertex.setProperty(SCHEMA, (Object)json);
                orientVertex.save();
            } else if (Relation.class.isAssignableFrom(baseType.getTypeClass())) {
                String sourceClass = typeDefinition.getSourceType();
                Vertex source = this.getVertex(orientGraph, sourceClass);
                String targetClass = typeDefinition.getTargetType();
                Vertex target = this.getVertex(orientGraph, targetClass);
                OrientEdge orientEdge = orientGraph.addEdge(null, source, target, typeDefinition.getName());
                orientEdge.setProperty(SCHEMA, (Object)json);
                orientEdge.save();
            } else if (Embedded.class.isAssignableFrom(baseType.getTypeClass())) {
                ODocument doc = new ODocument(typeDefinition.getName());
                doc.field(SCHEMA, (Object)json);
                doc.save();
            }
            orientGraph.commit();
            String string = json;
            return string;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new SchemaException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String read(String type, boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        return null;
    }

    public String update(String type, AccessType accessType, String json) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String delete(String type, AccessType accessType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }
}

