/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class EntityManagement<E extends Entity>
extends ERManagement<E, Vertex> {
    private static Logger logger = LoggerFactory.getLogger(EntityManagement.class);

    protected EntityManagement(Class<E> entityClass) {
        super(entityClass);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.baseType = Facet.class.isAssignableFrom(entityClass) ? "Facet" : (Resource.class.isAssignableFrom(entityClass) ? "Resource" : "Entity");
    }

    protected EntityManagement(Class<E> entityClass, OrientGraph orientGraph) {
        this(entityClass);
        this.orientGraph = orientGraph;
    }

    protected Vertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        logger.trace("Going to create {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.baseType, this.erType, this.jsonNode});
        try {
            OrientVertex vertexEntity = this.orientGraph.addVertex((Object)("class:" + this.erType));
            try {
                Vertex v = (Vertex)this.getElement();
                if (v != null) {
                    String error = String.format("A %s with UUID %s already exist", this.erType, this.uuid.toString());
                    throw new EntityAlreadyPresentException(error);
                }
            }
            catch (EntityAlreadyPresentException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
            this.element = vertexEntity;
            Header entityHeader = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)true);
            if (entityHeader != null) {
                ((Vertex)this.element).setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((Vertex)((Vertex)this.element), null);
            }
            if (!Resource.class.isAssignableFrom(this.erTypeClass)) {
                ERManagement.updateProperties((Element)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            }
            ContextUtility.addToActualContext((OrientGraph)this.orientGraph, (Element)this.element);
            ((OrientVertex)this.element).save();
            logger.info("Created {} is {}", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)((OrientVertex)this.element), (boolean)true));
            return (Vertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.baseType, this.erType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.erType + " with " + this.jsonNode, e.getCause());
        }
    }

    public boolean reallyAddToContext() throws ContextException, ResourceRegistryException {
        ContextUtility.addToActualContext((OrientGraph)this.orientGraph, (Element)this.getElement());
        Iterable edges = ((Vertex)this.element).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = RelationManagement.getRelationManagement((OrientGraph)this.orientGraph, (Edge)edge);
            relationManagement.reallyAddToContext();
        }
        return true;
    }

    public boolean reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        ContextUtility.removeFromActualContext((OrientGraph)this.orientGraph, (Element)this.getElement());
        Iterable edges = ((Vertex)this.element).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = RelationManagement.getRelationManagement((OrientGraph)this.orientGraph, (Edge)edge);
            relationManagement.reallyRemoveFromContext();
        }
        return true;
    }

    public static EntityManagement getEntityManagement(OrientGraph orientGraph, Vertex vertex) throws ResourceRegistryException {
        OrientVertexType orientVertexType = ((OrientVertex)vertex).getType();
        ResourceManagement entityManagement = null;
        if (orientVertexType.isSubClassOf("Resource")) {
            entityManagement = new ResourceManagement(orientGraph);
        } else if (orientVertexType.isSubClassOf("Facet")) {
            entityManagement = new FacetManagement(orientGraph);
        } else {
            String error = String.format("{%s is not a %s nor a %s. This is really strange and should not occur. Please Investigate it.", vertex, "Resource", "Facet");
            throw new ResourceRegistryException(error);
        }
        entityManagement.setElement((Element)vertex);
        return entityManagement;
    }

    public abstract Vertex reallyCreate() throws EntityAlreadyPresentException, ResourceRegistryException;

    public String create() throws EntityAlreadyPresentException, ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            this.element = this.reallyCreate();
            this.orientGraph.commit();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        JSONArray jsonArray = new JSONArray();
        Iterable iterable = this.orientGraph.getVerticesOfClass(this.erType, polymorphic);
        for (Vertex vertex : iterable) {
            EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)vertex);
            JSONObject jsonObject = entityManagement.serializeAsJson();
            jsonArray.put((Object)jsonObject);
        }
        return jsonArray.toString();
    }
}

