/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.relation;

import com.fasterxml.jackson.databind.JsonNode;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.embedded.PropagationConstraint;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RelationManagement<R extends Relation>
extends ERManagement<R, Edge> {
    private static Logger logger = LoggerFactory.getLogger(RelationManagement.class);
    protected final Class<? extends Entity> targetEntityClass;

    protected RelationManagement(Class<R> relationClass) {
        super(relationClass);
        this.ignoreKeys.add("header");
        this.ignoreKeys.add("target");
        this.ignoreKeys.add("source");
        this.ignoreKeys.add("in".toLowerCase());
        this.ignoreKeys.add("out".toLowerCase());
        this.ignoreKeys.add("in".toUpperCase());
        this.ignoreKeys.add("out".toUpperCase());
        if (ConsistsOf.class.isAssignableFrom(relationClass)) {
            this.baseType = "ConsistsOf";
            this.targetEntityClass = Facet.class;
        } else if (IsRelatedTo.class.isAssignableFrom(relationClass)) {
            this.baseType = "IsRelatedTo";
            this.targetEntityClass = Resource.class;
        } else {
            this.baseType = "Relation";
            this.targetEntityClass = Resource.class;
        }
    }

    protected RelationManagement(Class<R> relationClass, OrientGraph orientGraph) {
        this(relationClass);
        this.orientGraph = orientGraph;
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JSONObject serializeAsJson() throws ResourceRegistryException {
        JSONObject relation = this.serializeSelfOnly();
        Vertex target = ((Edge)this.element).getVertex(Direction.IN);
        EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)target);
        try {
            relation.put("target", (Object)entityManagement.serializeAsJson());
        }
        catch (JSONException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected Map<String, JSONObject> fullSerialize(Map<String, JSONObject> visitedSourceResources) throws ResourceRegistryException {
        Vertex source = ((Edge)this.element).getVertex(Direction.OUT);
        String id = source.getId().toString();
        JSONObject sourceResource = visitedSourceResources.get(id);
        if (sourceResource == null) {
            ResourceManagement resourceManagement = (ResourceManagement)EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)source);
            if (this instanceof IsRelatedToManagement) {
                sourceResource = resourceManagement.serializeAsJson();
            } else if (this instanceof ConsistsOfManagement) {
                sourceResource = resourceManagement.serializeSelfOnly();
            } else {
                String error = String.format("{%s is not a %s nor a %s. This is really strange and should not occur. Please Investigate it.", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName());
                throw new ResourceRegistryException(error);
            }
        }
        if (this instanceof IsRelatedToManagement) {
            sourceResource = ResourceManagement.addIsRelatedTo((JSONObject)sourceResource, (JSONObject)this.serializeAsJson());
        } else if (this instanceof ConsistsOfManagement) {
            sourceResource = ResourceManagement.addConsistsOf((JSONObject)sourceResource, (JSONObject)this.serializeAsJson());
        } else {
            String error = String.format("{%s is not a %s nor a %s. This is really strange and should not occur. Please Investigate it.", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName());
            throw new ResourceRegistryException(error);
        }
        visitedSourceResources.put(id, sourceResource);
        return visitedSourceResources;
    }

    public Edge reallyCreate(UUID sourceUUID, UUID targetUUID) throws ResourceRegistryException {
        ResourceManagement srmSource = new ResourceManagement(this.orientGraph);
        srmSource.setUUID(sourceUUID);
        Vertex source = (Vertex)srmSource.getElement();
        EntityManagement entityManagement = this.getEntityManagement();
        entityManagement.setUUID(targetUUID);
        Vertex target = (Vertex)entityManagement.getElement();
        return this.reallyCreate(source, target);
    }

    protected Edge reallyCreate(Vertex source, Vertex target) throws ResourceRegistryException {
        EntityManagement sourceEntityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)source);
        EntityManagement targetEntityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)target);
        if (!(sourceEntityManagement instanceof ResourceManagement)) {
            String error = String.format("Any type of %s can have only a %s as %s. Cannot instatiate %s beetween %s -> %s ", "Relation", "Resource", "source", this.erType, sourceEntityManagement.serialize(), targetEntityManagement.serialize());
            throw new ResourceRegistryException(error);
        }
        if (this instanceof IsRelatedToManagement) {
            if (!(targetEntityManagement instanceof ResourceManagement)) {
                String error = String.format("A %s can have only a %s as %s. Cannot instatiate %s beetween %s -> %s ", this.baseType, "Resource", "target", this.erType, sourceEntityManagement.serialize(), targetEntityManagement.serialize());
                throw new ResourceRegistryException(error);
            }
        } else if (this instanceof ConsistsOfManagement) {
            if (!(targetEntityManagement instanceof FacetManagement)) {
                String error = String.format("A %s can have only a %s as %s. Cannot instatiate %s beetween %s -> %s ", this.baseType, "Facet", "target", this.erType, sourceEntityManagement.serialize(), targetEntityManagement.serialize());
                throw new ResourceRegistryException(error);
            }
        } else {
            String error = String.format("{%s is not a %s nor a %s. This is really strange and should not occur. Please Investigate it.", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName());
            throw new ResourceRegistryException(error);
        }
        logger.trace("Creating {} beetween {} -> {}", new Object[]{this.erType, sourceEntityManagement.serialize(), targetEntityManagement.serialize()});
        this.element = this.orientGraph.addEdge(null, source, target, this.erType);
        ERManagement.updateProperties((Element)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        HeaderUtility.addHeader((Edge)((Edge)this.element), null);
        ContextUtility.addToActualContext((OrientGraph)this.orientGraph, (Element)this.element);
        ((OrientEdge)this.element).save();
        logger.info("{} successfully created", (Object)this.erType);
        return (Edge)this.element;
    }

    public Edge reallyCreate(Vertex source) throws ResourceRegistryException {
        Vertex target = null;
        EntityManagement entityManagement = this.getEntityManagement();
        if (!this.jsonNode.has("target")) {
            throw new ResourceRegistryException("Error while creating relation. No target definition found");
        }
        entityManagement.setJSON(this.jsonNode.get("target"));
        try {
            target = (Vertex)entityManagement.getElement();
        }
        catch (Exception e) {
            target = entityManagement.reallyCreate();
        }
        return this.reallyCreate(source, target);
    }

    public Edge reallyCreate(UUID sourceUUID) throws ResourceRegistryException {
        ResourceManagement srmSource = new ResourceManagement(this.orientGraph);
        srmSource.setUUID(sourceUUID);
        Vertex source = (Vertex)srmSource.getElement();
        return this.reallyCreate(source);
    }

    public Edge reallyUpdate() throws ResourceRegistryException {
        JsonNode target;
        logger.debug("Trying to update {} : {}", (Object)this.erType, (Object)this.jsonNode);
        Edge edge = (Edge)this.getElement();
        ERManagement.updateProperties((Element)edge, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        if (ConsistsOf.class.isAssignableFrom(this.erTypeClass) && (target = this.jsonNode.get("target")) != null) {
            FacetManagement fm = new FacetManagement(this.orientGraph);
            fm.setJSON(target);
            fm.reallyUpdate();
        }
        logger.info("{} {} successfully updated", (Object)this.erType, (Object)this.jsonNode);
        return edge;
    }

    public boolean reallyAddToContext() throws ContextException, ResourceRegistryException {
        this.getElement();
        PropagationConstraint.AddConstraint addConstraint = PropagationConstraint.AddConstraint.unpropagate;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getEmbedded(PropagationConstraint.class, (Element)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getAddConstraint() != null) {
                addConstraint = propagationConstraint.getAddConstraint();
            }
        }
        catch (Exception e) {
            logger.warn("Error while getting {} from {}. Assuming {}. This is really strange and should not occur. Please Investigate it.", new Object[]{"propagationConstraint", Utility.toJsonString((Element)this.element, (boolean)true), addConstraint});
        }
        Vertex target = ((Edge)this.element).getVertex(Direction.IN);
        switch (1.$SwitchMap$org$gcube$informationsystem$model$embedded$PropagationConstraint$AddConstraint[addConstraint.ordinal()]) {
            case 1: {
                ContextUtility.addToActualContext((OrientGraph)this.orientGraph, (Element)this.getElement());
                EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)target);
                entityManagement.reallyAddToContext();
                break;
            }
            case 2: {
                break;
            }
        }
        return true;
    }

    protected boolean removeFromContextTargetVertex(Vertex target) throws ResourceRegistryException {
        EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)target);
        if (entityManagement != null) {
            entityManagement.reallyRemoveFromContext();
            return true;
        }
        return false;
    }

    public boolean reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        this.getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getEmbedded(PropagationConstraint.class, (Element)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getRemoveConstraint() != null) {
                removeConstraint = propagationConstraint.getRemoveConstraint();
            }
        }
        catch (Exception e) {
            logger.warn("Error while getting {} from {}. Assuming {}. This is really strange and should not occur. Please Investigate it.", new Object[]{"propagationConstraint", Utility.toJsonString((Element)this.element, (boolean)true), removeConstraint});
        }
        Vertex target = ((Edge)this.element).getVertex(Direction.IN);
        ContextUtility.removeFromActualContext((OrientGraph)this.orientGraph, (Element)this.element);
        switch (1.$SwitchMap$org$gcube$informationsystem$model$embedded$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                this.removeFromContextTargetVertex(target);
                break;
            }
            case 2: {
                Iterable iterable = target.getEdges(Direction.IN, new String[0]);
                Iterator iterator = iterable.iterator();
                if (iterator.hasNext()) {
                    logger.trace("{} point to {} which is not orphan. Giving {} directive, it will be not remove from current context.", new Object[]{this.element, target, removeConstraint});
                    break;
                }
                this.removeFromContextTargetVertex(target);
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected EntityManagement getEntityManagement() throws ResourceRegistryException {
        FacetManagement entityManagement;
        if (ConsistsOf.class.isAssignableFrom(this.erTypeClass)) {
            entityManagement = new FacetManagement(this.orientGraph);
        } else if (IsRelatedTo.class.isAssignableFrom(this.erTypeClass)) {
            entityManagement = new ResourceManagement(this.orientGraph);
        } else {
            String error = String.format("{%s is not a %s nor a %s. This is really strange ad should not occur. Please Investigate it.", this.erTypeClass, "ConsistsOf", "IsRelatedTo");
            throw new ResourceRegistryException(error);
        }
        return entityManagement;
    }

    public static RelationManagement getRelationManagement(OrientGraph orientGraph, Edge edge) throws ResourceRegistryException {
        OrientEdgeType orientEdgeType = ((OrientEdge)edge).getType();
        ConsistsOfManagement relationManagement = null;
        if (orientEdgeType.isSubClassOf("ConsistsOf")) {
            relationManagement = new ConsistsOfManagement(orientGraph);
        } else if (orientEdgeType.isSubClassOf("IsRelatedTo")) {
            relationManagement = new IsRelatedToManagement(orientGraph);
        } else {
            String error = String.format("{%s is not a %s nor a %s. This is really strange ad should not occur. Please Investigate it.", edge, "ConsistsOf", "IsRelatedTo");
            throw new ResourceRegistryException(error);
        }
        relationManagement.setElement((Element)edge);
        return relationManagement;
    }

    protected boolean deleteTargetVertex(Vertex target) throws ResourceRegistryException {
        EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)target);
        if (entityManagement != null) {
            entityManagement.reallyDelete();
            return true;
        }
        return false;
    }

    public boolean reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        logger.debug("Going to remove {} with UUID {}. Related {}s will be detached.", new Object[]{this.baseType, this.uuid, this.targetEntityClass.getSimpleName()});
        this.getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getEmbedded(PropagationConstraint.class, (Element)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getRemoveConstraint() != null) {
                removeConstraint = propagationConstraint.getRemoveConstraint();
            }
        }
        catch (Exception e) {
            logger.warn("Error while getting {} from {}. Assuming {}. This is really strange and should not occur. Please Investigate it.", new Object[]{"propagationConstraint", Utility.toJsonString((Element)this.element, (boolean)true), removeConstraint});
        }
        Vertex target = ((Edge)this.element).getVertex(Direction.IN);
        ((Edge)this.element).remove();
        switch (1.$SwitchMap$org$gcube$informationsystem$model$embedded$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                this.deleteTargetVertex(target);
                break;
            }
            case 2: {
                Iterable iterable = target.getEdges(Direction.IN, new String[0]);
                Iterator iterator = iterable.iterator();
                if (iterator.hasNext()) {
                    logger.trace("{} point to {} which is not orphan. Giving {} directive, it will be keep.", new Object[]{this.element, target, removeConstraint});
                    break;
                }
                this.deleteTargetVertex(target);
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    public String create(UUID sourceUUID, UUID targetUUID) throws ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            this.element = this.reallyCreate(sourceUUID, targetUUID);
            this.orientGraph.commit();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    protected Collection<JSONObject> serializeEdges(Iterable<Edge> edges, boolean postFilterPolymorphic) throws ResourceRegistryException {
        Map visitedSourceResources = new HashMap();
        for (Edge edge : edges) {
            if (postFilterPolymorphic && edge.getLabel().compareTo(this.erType) != 0) continue;
            RelationManagement relationManagement = RelationManagement.getRelationManagement((OrientGraph)this.orientGraph, (Edge)edge);
            visitedSourceResources = relationManagement.fullSerialize(visitedSourceResources);
        }
        return visitedSourceResources.values();
    }

    protected String serializeJSONObjectList(Collection<JSONObject> list) {
        JSONArray jsonArray = new JSONArray(list);
        return jsonArray.toString();
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        Iterable edges = this.orientGraph.getEdgesOfClass(this.erType, polymorphic);
        Collection collection = this.serializeEdges(edges, false);
        return this.serializeJSONObjectList(collection);
    }

    public String reallyGetAllFrom(UUID uuid, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        EntityManagement entityManagement = null;
        try {
            entityManagement = (EntityManagement)ERManagement.getERManagementFromUUID((OrientGraph)this.orientGraph, (UUID)uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException(String.format("Provided UUID %s does not belogn to any %s", uuid.toString(), "Entity"));
        }
        Vertex vertex = (Vertex)entityManagement.getElement();
        ArrayList list = new ArrayList();
        Iterable edges = vertex.getEdges(direction, new String[]{this.erType});
        list.addAll(this.serializeEdges(edges, !polymorphic));
        return this.serializeJSONObjectList(list);
    }

    public String allFrom(UUID uuid, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            String string = this.reallyGetAllFrom(uuid, direction, polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }
}

