package org.gcube.informationsystem.resourceregistry.schema;

import java.util.List;

import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.types.reference.Type;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public interface ResourceRegistrySchemaClient {

	public void addHeader(String name, String value);
	
	public String create(String typeDefinitition) throws SchemaException, ResourceRegistryException;
	
	public <E extends Element> Type create(Class<E> clz) throws SchemaException, ResourceRegistryException;

	public boolean exist(String typeName) throws ResourceRegistryException;

	public <E extends Element> boolean exist(Class<E> clz) throws ResourceRegistryException;

	public String read(String typeName, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException;

	public <E extends Element> List<Type> read(Class<E> clz, Boolean polymorphic)
			throws SchemaNotFoundException, ResourceRegistryException;

}
