/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientImpl
implements ResourceRegistrySchemaClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientImpl.class);
    protected final String address;

    public ResourceRegistrySchemaClientImpl(String address) {
        this.address = address;
    }

    @Override
    public <ISM extends ISManageable> TypeBinder.TypeDefinition create(Class<ISM> clz) throws SchemaException, ResourceRegistryException {
        try {
            String typeDefinition = TypeBinder.serializeType(clz);
            String type = AccessType.getAccessType(clz).getName();
            String res = this.create(type, typeDefinition);
            return TypeBinder.deserializeTypeDefinition((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String baseType, String typeDefinitition) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)typeDefinitition);
            TypeBinder.TypeDefinition typeDefinitionObj = TypeBinder.deserializeTypeDefinition((String)typeDefinitition);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistrySchemaClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeDefinitionObj.getName());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(typeDefinitition);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> read(Class<ISM> clz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getType(clz);
            String res = this.read(type, polymorphic);
            return TypeBinder.deserializeTypeDefinitions((String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String type, Boolean polymorphic) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} schema", (Object)type);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistrySchemaClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (polymorphic != null) {
                parameters.put("polymorphic", polymorphic.toString());
            }
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got schema for {} is {}", (Object)type, (Object)json);
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

