package org.gcube.informationsystem.resourceregistry.publisher;

import org.gcube.informationsystem.resourceregistry.api.Constants;
import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ResourceRegistryPublisherFactory {
	
	private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherFactory.class);
	
	/**
	 * Gets the Resource Registry service URL using the current context.
	 * 
	 * @return The complete URL for the Resource Registry service
	 */
	public static String getResourceRegistryURL() {
		String address = String.format("%s/%s", ServiceInstance.getServiceURL(),Constants.SERVICE_NAME);
		return address;
	}
	
	/**
	 * Gets the Resource Registry service URL for a specific context.
	 * 
	 * @param context The context to use for determining the service URL
	 * @return The complete URL for the Resource Registry service in the specified context
	 */
	public static String getResourceRegistryURL(String context) {
		String address = String.format("%s/%s", ServiceInstance.getServiceURL(context),Constants.SERVICE_NAME);
		return address;
	}
	
	/**
	 * Creates a new ResourceRegistryPublisher instance using the current context.
	 * 
	 * @return A new ResourceRegistryPublisher instance configured for the current context
	 */
	public static ResourceRegistryPublisher create() {
		String address = getResourceRegistryURL();
		logger.trace("The {} will be contacted at {}", Constants.SERVICE_NAME, address);
		return new ResourceRegistryPublisherImpl(address);
	}

	/**
	 * Creates a new ResourceRegistryPublisher instance for a specific context.
	 * 
	 * @param context The context to use for the ResourceRegistryPublisher instance
	 * @return A new ResourceRegistryPublisher instance configured for the specified context
	 */
	public static ResourceRegistryPublisher create(String context) {
		String address = getResourceRegistryURL(context);
		logger.trace("The {} will be contacted at {}", Constants.SERVICE_NAME, address);
		return new ResourceRegistryPublisherImpl(address);
	}
	
}
