/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherImpl
implements ResourceRegistryPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected final String address;
    protected HTTPCall httpCall;

    public ResourceRegistryPublisherImpl(String address) {
        this.address = address;
    }

    protected HTTPCall getHTTPCall() throws MalformedURLException {
        if (this.httpCall == null) {
            this.httpCall = new HTTPCall(this.address, ResourceRegistryPublisher.class.getSimpleName());
        }
        return this.httpCall;
    }

    private static String getCurrentContext() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    @Override
    @Deprecated
    public <F extends Facet> F createFacet(Class<F> facetClass, F facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        try {
            return this.createFacet(facet);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> F createFacet(F facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        try {
            String facetString = ISMapper.marshal(facet);
            String facetType = Utility.getType(facet);
            String res = this.createFacet(facetType, facetString);
            return (F)((Facet)ISMapper.unmarshal(Facet.class, (String)res));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createFacet(String facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        try {
            String facetType = Utility.getClassFromJsonString((String)facet);
            return this.createFacet(facetType, facet);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createFacet(String facetType, String facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facetType);
            HTTPCall httpCall = this.getHTTPCall();
            String f = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, facet);
            logger.trace("{} successfully created", (Object)f);
            return f;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public <F extends Facet> F updateFacet(Class<F> facetClass, F facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            return this.updateFacet(facet);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> F updateFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            String facetString = ISMapper.marshal(facet);
            UUID uuid = facet.getHeader().getUUID();
            String res = this.updateFacet(uuid, facetString);
            return (F)((Facet)ISMapper.unmarshal(Facet.class, (String)res));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String updateFacet(String facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            UUID uuid = Utility.getUUIDFromJsonString((String)facet);
            return this.updateFacet(uuid, facet);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String updateFacet(UUID uuid, String facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to update: {}", (Object)facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String f = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, facet);
            logger.trace("{} successfully updated", (Object)f);
            return f;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> boolean deleteFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("Going to delete : {}", facet);
        return this.deleteFacet(facet.getHeader().getUUID());
    }

    @Override
    public boolean deleteFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"Facet", (Object)uuid.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"Facet", uuid.toString(), deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public <R extends Resource> R createResource(Class<R> resourceClass, R resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        try {
            return this.createResource(resource);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> R createResource(R resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        try {
            String resourceString = ISMapper.marshal(resource);
            String resourceType = Utility.getType(resource);
            String res = this.createResource(resourceType, resourceString);
            return (R)((Resource)ISMapper.unmarshal(Resource.class, (String)res));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createResource(String resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        try {
            String resourceType = Utility.getClassFromJsonString((String)resource);
            return this.createResource(resourceType, resource);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createResource(String resourceType, String resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resourceType);
            HTTPCall httpCall = this.getHTTPCall();
            String r = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, resource);
            logger.trace("{} successfully created", (Object)r);
            return r;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public <R extends Resource> R updateResource(Class<R> resourceClass, R resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            return this.updateResource(resource);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> R updateResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            String resourceString = ISMapper.marshal(resource);
            UUID uuid = resource.getHeader().getUUID();
            String res = this.updateResource(uuid, resourceString);
            return (R)((Resource)ISMapper.unmarshal(Resource.class, (String)res));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String updateResource(String resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            UUID uuid = Utility.getUUIDFromJsonString((String)resource);
            return this.updateResource(uuid, resource);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String updateResource(UUID uuid, String resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to update: {}", (Object)resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            String r = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, resource);
            logger.trace("{} successfully updated", (Object)r);
            return r;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> boolean deleteResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        logger.info("Going to delete {}", resource);
        return this.deleteResource(resource.getHeader().getUUID());
    }

    @Override
    public boolean deleteResource(UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"Resource", (Object)uuid.toString());
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"Resource", uuid.toString(), deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(Class<C> consistsOfClass, C consistsOf) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            return this.createConsistsOf(consistsOf);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C consistsOf) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            String consistsOfString = ISMapper.marshal(consistsOf);
            String consistsOfType = Utility.getType(consistsOf);
            String res = this.createConsistsOf(consistsOfType, consistsOfString);
            return (C)((ConsistsOf)ISMapper.unmarshal(ConsistsOf.class, (String)res));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createConsistsOf(String consistsOf) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            String consistsOfType = Utility.getClassFromJsonString((String)consistsOf);
            return this.createConsistsOf(consistsOfType, consistsOf);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createConsistsOf(String consistsOfType, String consistsOf) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)consistsOf);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("consistsOf");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(consistsOfType);
            HTTPCall httpCall = this.getHTTPCall();
            String c = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, consistsOf);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C consistsOf) throws ResourceRegistryException {
        return this.deleteConsistsOf(consistsOf.getHeader().getUUID());
    }

    @Override
    public boolean deleteConsistsOf(UUID uuid) throws ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"ConsistsOf", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("consistsOf");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"ConsistsOf", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(Class<I> isRelatedToClass, I isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            return this.createIsRelatedTo(isRelatedTo);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            String isRelatedToString = ISMapper.marshal(isRelatedTo);
            String isRelatedToType = Utility.getType(isRelatedTo);
            String res = this.createIsRelatedTo(isRelatedToType, isRelatedToString);
            return (I)((IsRelatedTo)ISMapper.unmarshal(IsRelatedTo.class, (String)res));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createIsRelatedTo(String isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            String isRelatedToType = Utility.getClassFromJsonString((String)isRelatedTo);
            return this.createIsRelatedTo(isRelatedToType, isRelatedTo);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createIsRelatedTo(String isRelatedToType, String isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)isRelatedTo);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("isRelatedTo");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(isRelatedToType);
            HTTPCall httpCall = this.getHTTPCall();
            String i = (String)httpCall.call(String.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, isRelatedTo);
            logger.trace("{} successfully created", (Object)i);
            return i;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I isRelatedTo) throws ResourceRegistryException {
        return this.deleteIsRelatedTo(isRelatedTo.getHeader().getUUID());
    }

    @Override
    public boolean deleteIsRelatedTo(UUID uuid) throws ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"IsRelatedTo", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("isRelatedTo");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean deleted = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE);
            logger.info("{} with UUID {} {}", new Object[]{"IsRelatedTo", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addResourceToContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("add");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean added = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} added to current {} : {}", new Object[]{"Resource", uuid, added ? "successfully" : "NOT", "Context", context});
            return added;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> boolean addResourceToContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addResourceToContext(resource.getHeader().getUUID());
    }

    @Override
    public boolean addFacetToContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("add");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean added = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} added to current {} : {}", new Object[]{"Facet", uuid, added ? "successfully" : "NOT", "Context", context});
            return added;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> boolean addFacetToContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addFacetToContext(facet.getHeader().getUUID());
    }

    @Override
    public boolean removeResourceFromContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("remove");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean removed = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} removed from current {} : {}", new Object[]{"Resource", uuid, removed ? "successfully" : "NOT", "Context", context});
            return removed;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource> boolean removeResourceFromContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeResourceFromContext(resource.getHeader().getUUID());
    }

    @Override
    public boolean removeFacetFromContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("remove");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = this.getHTTPCall();
            boolean removed = (Boolean)httpCall.call(Boolean.class, stringWriter.toString(), HTTPCall.HTTPMETHOD.POST);
            logger.info("{} with UUID {} was {} removed from current {} : {}", new Object[]{"Facet", uuid, removed ? "successfully" : "NOT", "Context", context});
            return removed;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> boolean removeFacetFromContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFacetFromContext(facet.getHeader().getUUID());
    }
}

