package org.gcube.smartgears.connector.resourceregistry.resourcemanager;

import java.util.UUID;

import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;

/**
 * Marker interface for Resource Managers
 * @author Luca Frosini (ISTI-CNR)
 */
public class ResourceManager {

	/** The Resource Registry Publisher instance */
    protected ResourceRegistryPublisher resourceRegistryPublisher;

	/**
	 * Constructor
	 */
    public ResourceManager() {
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
    }

    /**
	 * Gets the UUID of a context by its full name.
	 * 
	 * @param contextFullName the full name of the context
	 * @return the UUID of the context
	 * @throws ResourceRegistryException if an error occurs
	 */
	protected UUID getContextUUID(String contextFullName) throws ResourceRegistryException {
		ContextCache contextCache = resourceRegistryPublisher.getContextCache();
		UUID contextUUID = contextCache.getUUIDByFullName(contextFullName);
		return contextUUID;
	}
}
