/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.connector.resourceregistry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.smartgears.configuration.AuthorizationProviderConfiguration;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.EServiceManager;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.HostingNodeManager;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.ResourceManager;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.publishing.SmartgearsProfilePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmartgearsProfilePublisher
public class FacetBasedPublisher
implements Publisher {
    private static Logger logger = LoggerFactory.getLogger(FacetBasedPublisher.class);
    private static Map<String, ResourceManager> managersCache = new HashMap<String, ResourceManager>();
    protected ResourceRegistryPublisher resourceRegistryPublisher;

    public static AuthorizationProvider getAuthorizationProvider(ApplicationContext applicationContext) {
        return FacetBasedPublisher.getAuthorizationProvider(applicationContext.container());
    }

    public static AuthorizationProvider getAuthorizationProvider(ContainerContext containerContext) {
        AuthorizationProviderConfiguration authorizationProviderConfiguration = containerContext.configuration().authorizationConfiguration();
        AuthorizationProviderFactory authorizationProviderFactory = authorizationProviderConfiguration.getAuthProviderFactory();
        AuthorizationProvider authorizationProvider = authorizationProviderFactory.connect(authorizationProviderConfiguration.getCredentials());
        return authorizationProvider;
    }

    public UUID getContextUUID(String contextFullName) throws ResourceRegistryException {
        ContextCache contextCache = this.resourceRegistryPublisher.getContextCache();
        UUID contextUUID = contextCache.getUUIDByFullName(contextFullName);
        return contextUUID;
    }

    public boolean create(ContainerContext containerContext, Set<String> contexts) {
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        TreeSet<String> contextToIterate = new TreeSet<String>(contexts);
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                if (this.resourceRegistryPublisher == null) {
                    this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                }
                HostingNodeManager hostingNodeManager = null;
                String containerID = containerContext.id();
                if (managersCache.containsKey(containerID)) {
                    hostingNodeManager = (HostingNodeManager)managersCache.get(containerID);
                } else {
                    hostingNodeManager = new HostingNodeManager(containerContext, this.resourceRegistryPublisher);
                    managersCache.put(containerID, hostingNodeManager);
                }
                for (String c : contextToIterate) {
                    try {
                        if (context.compareTo(c) == 0) {
                            hostingNodeManager.createHostingNode();
                            continue;
                        }
                        hostingNodeManager.addToContext(c);
                    }
                    catch (Throwable e) {
                        logger.error("Error while publishing {} (id='{}') in context '{}'", new Object[]{"HostingNode", containerID, context, e});
                    }
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Error while publishing {} (id='{}')", new Object[]{"HostingNode", containerContext.id(), e});
        }
        return true;
    }

    public boolean create(ApplicationContext applicationContext, Set<String> contexts) {
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        TreeSet<String> contextToIterate = new TreeSet<String>(contexts);
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                if (this.resourceRegistryPublisher == null) {
                    this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                }
                EServiceManager eServiceManager = null;
                String applicationID = applicationContext.id();
                if (managersCache.containsKey(applicationID)) {
                    eServiceManager = (EServiceManager)managersCache.get(applicationID);
                } else {
                    eServiceManager = new EServiceManager(applicationContext, this.resourceRegistryPublisher);
                    managersCache.put(applicationID, eServiceManager);
                }
                for (String c : contextToIterate) {
                    try {
                        if (context.compareTo(c) == 0) {
                            eServiceManager.createEService();
                            continue;
                        }
                        eServiceManager.addToContext(c);
                    }
                    catch (Throwable e) {
                        logger.error("Error while publishing {} (name='{}', id='{}') in context '{}'", new Object[]{"EService", applicationContext.name(), applicationID, context, e});
                    }
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Error while publishing {} (name='{}', id='{}')", new Object[]{"EService", applicationContext.name(), applicationContext.id(), e});
        }
        return true;
    }

    public boolean remove(ContainerContext containerContext, Set<String> contexts) {
        HostingNodeManager hostingNodeManager = (HostingNodeManager)managersCache.get(containerContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        for (String context : contexts) {
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        hostingNodeManager.removeFromCurrentContext();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)authorizationProvider.getSecretForContext(context));
            }
            catch (Throwable e) {
                logger.error("Unable to remove {} (id='{}') from context '{}'", new Object[]{"HostingNode", containerContext.id(), context, e});
            }
        }
        return false;
    }

    public boolean remove(ApplicationContext applicationContext, Set<String> contexts) {
        EServiceManager eServiceManager = (EServiceManager)managersCache.get(applicationContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        for (String context : contexts) {
            try {
                AuthorizedTasks.executeSafely(() -> {
                    try {
                        eServiceManager.removeFromCurrentContext();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (Secret)authorizationProvider.getSecretForContext(context));
            }
            catch (Throwable e) {
                logger.error("Unable to remove {} (name='{}', id='{}') from context '{}'", new Object[]{"EService", applicationContext.name(), applicationContext.id(), context, e});
            }
        }
        return true;
    }

    public boolean update(ContainerContext containerContext) {
        HostingNodeManager hostingNodeManager = (HostingNodeManager)managersCache.get(containerContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        TreeSet contextToIterate = new TreeSet(authorizationProvider.getContexts());
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                try {
                    hostingNodeManager.updateFacets();
                }
                catch (ResourceRegistryException e) {
                    throw new RuntimeException(e);
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Unable to update {} (id='{}')", new Object[]{"HostingNode", containerContext.id(), e});
        }
        return true;
    }

    public boolean update(ApplicationContext applicationContext) {
        EServiceManager eServiceManager = (EServiceManager)managersCache.get(applicationContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        TreeSet contextToIterate = new TreeSet(authorizationProvider.getContexts());
        String context = (String)contextToIterate.first();
        try {
            AuthorizedTasks.executeSafely(() -> {
                try {
                    eServiceManager.updateFacets();
                }
                catch (ResourceRegistryException e) {
                    throw new RuntimeException(e);
                }
            }, (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Unable to update {} (name='{}', id='{}') ", new Object[]{"EService", applicationContext.name(), applicationContext.id(), e});
        }
        return true;
    }
}

