/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.orientdb.hooks;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;

public abstract class RelationHook
extends ODocumentHookAbstract
implements ODatabaseLifecycleListener {
    protected final String relationType;
    protected final PropagationConstraint propagationConstraint;

    protected void init(String relationType) {
        this.setIncludeClasses(new String[]{relationType});
    }

    public RelationHook(String relationType, PropagationConstraint propagationConstraint) {
        this.relationType = relationType;
        this.propagationConstraint = propagationConstraint;
        this.init(relationType);
    }

    public RelationHook(ODatabaseDocument database, String relationType, PropagationConstraint propagationConstraint) {
        super(database);
        this.relationType = relationType;
        this.propagationConstraint = propagationConstraint;
        this.init(relationType);
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    protected <T extends Enum> ORecordHook.RESULT fixConstraint(ORecordHook.RESULT result, ODocument oDocument, String property, Class<T> clz, T enumValue) {
        Object propertyObject = oDocument.field(property);
        if (propertyObject == null) {
            OLogManager.instance().debug((Object)this, "%s not present. Going to create it on %s", new Object[]{property, oDocument.toJSON()});
            oDocument.field(property, (Object)enumValue.toString());
            result = ORecordHook.RESULT.RECORD_CHANGED;
        } else {
            try {
                Enum.valueOf(clz, propertyObject.toString());
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "%s is not a valid value for % in %. Going to set default value %s.", new Object[]{propertyObject.toString(), property, this.relationType, enumValue.toString()});
                oDocument.field(property, (Object)enumValue.toString());
                result = ORecordHook.RESULT.RECORD_CHANGED;
            }
        }
        return result;
    }

    protected ORecordHook.RESULT checkPropagationConstraint(ODocument iDocument) {
        OLogManager.instance().debug((Object)this, "Checking %s on %s", new Object[]{"PropagationConstraint", iDocument.toJSON()});
        ORecordHook.RESULT result = ORecordHook.RESULT.RECORD_NOT_CHANGED;
        ODocument oDocument = (ODocument)iDocument.field("propagationConstraint");
        if (oDocument == null) {
            OLogManager.instance().debug((Object)this, "%s not present. Going to create it on %s", new Object[]{"PropagationConstraint", iDocument.toJSON()});
            oDocument = new ODocument("PropagationConstraint");
            oDocument.field("remove", (Object)this.propagationConstraint.getRemoveConstraint().toString());
            oDocument.field("add", (Object)this.propagationConstraint.getAddConstraint().toString());
            iDocument.field("propagationConstraint", (Object)oDocument);
            OLogManager.instance().debug((Object)this, "%s has now a %s", new Object[]{iDocument.toJSON(), "PropagationConstraint"});
            result = ORecordHook.RESULT.RECORD_CHANGED;
        } else {
            OLogManager.instance().debug((Object)this, "%s already present on %s. Going to validate it.", new Object[]{"propagationConstraint", iDocument.toJSON()});
            result = this.fixConstraint(result, oDocument, "remove", PropagationConstraint.RemoveConstraint.class, this.propagationConstraint.getRemoveConstraint());
            result = this.fixConstraint(result, oDocument, "add", PropagationConstraint.AddConstraint.class, this.propagationConstraint.getAddConstraint());
        }
        return result;
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        return this.checkPropagationConstraint(iDocument);
    }

    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        return this.checkPropagationConstraint(iDocument);
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.REGULAR;
    }

    public void onCreate(ODatabaseInternal iDatabase) {
        iDatabase.registerHook((ORecordHook)this);
    }

    public void onOpen(ODatabaseInternal iDatabase) {
        iDatabase.registerHook((ORecordHook)this);
    }

    public void onClose(ODatabaseInternal iDatabase) {
        iDatabase.unregisterHook((ORecordHook)this);
    }

    public void onDrop(ODatabaseInternal iDatabase) {
        iDatabase.unregisterHook((ORecordHook)this);
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }
}

