/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.orientdb.hooks;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Calendar;
import java.util.UUID;

public class HeaderHook
extends ODocumentHookAbstract
implements ODatabaseLifecycleListener {
    protected void init() {
        this.setIncludeClasses(new String[]{"Entity", "Relation"});
    }

    public HeaderHook() {
        this.init();
    }

    public HeaderHook(ODatabaseDocument database) {
        super(database);
        this.init();
    }

    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        OLogManager.instance().debug((Object)this, "Checking %s on %s", new Object[]{"Header", iDocument.toJSON()});
        ODocument oDocument = (ODocument)iDocument.field("header");
        if (oDocument == null) {
            OLogManager.instance().debug((Object)this, "%s not present. Going to create it on %s", new Object[]{"Header", iDocument.toJSON()});
            oDocument = new ODocument("Header");
            UUID uuid = UUID.randomUUID();
            oDocument.field("uuid", (Object)uuid.toString());
            OLogManager.instance().debug((Object)this, "Creator is unknown setting as %s", new Object[]{"UNKNOWN_USER"});
            oDocument.field("creator", (Object)"UNKNOWN_USER");
            long timestamp = Calendar.getInstance().getTimeInMillis();
            oDocument.field("creationTime", (Object)timestamp);
            oDocument.field("lastUpdateTime", (Object)timestamp);
            iDocument.field("header", (Object)oDocument);
            OLogManager.instance().debug((Object)this, "%s has now an %s", new Object[]{iDocument.toJSON(), "Header"});
            return ORecordHook.RESULT.RECORD_CHANGED;
        }
        OLogManager.instance().debug((Object)this, "%s already present on %s", new Object[]{"Header", iDocument.toJSON()});
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        OLogManager.instance().debug((Object)this, "Updating Last Update Time on %s of %s", new Object[]{"Header", iDocument.toJSON()});
        ODocument oDocument = (ODocument)iDocument.field("header");
        Calendar calendar = Calendar.getInstance();
        long timestamp = calendar.getTimeInMillis();
        oDocument.field("lastUpdateTime", (Object)timestamp);
        OLogManager.instance().debug((Object)this, "Updated Document is %s", new Object[]{iDocument});
        return ORecordHook.RESULT.RECORD_CHANGED;
    }

    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.REGULAR;
    }

    public void onCreate(ODatabaseInternal iDatabase) {
        iDatabase.registerHook((ORecordHook)this);
    }

    public void onOpen(ODatabaseInternal iDatabase) {
        iDatabase.registerHook((ORecordHook)this);
    }

    public void onClose(ODatabaseInternal iDatabase) {
        iDatabase.unregisterHook((ORecordHook)this);
    }

    public void onDrop(ODatabaseInternal iDatabase) {
        iDatabase.unregisterHook((ORecordHook)this);
    }

    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }
}

