/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.reference.ContextState;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClient;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.utils.UUIDManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientImpl
extends BaseRequestInfo
implements ResourceRegistryContextClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientImpl.class);
    private static final String ACCEPT_HTTP_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER_KEY = "Content-Type";
    protected final String address;
    protected Map<String, String> headers;
    protected ContextCache contextCache;
    protected ContextCacheRenewal contextCacheRenewal = new ContextCacheRenewal(){

        public List<Context> renew() throws ResourceRegistryException {
            return ResourceRegistryContextClientImpl.this.getAllContextFromServer(true, 0, BaseRequestInfo.UNBOUNDED_LIMIT);
        }
    };

    private void addOptionalQueryParameters(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addIncludeMeta(queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        return this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        this.addOptionalQueryParameters(queryParams);
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    private void addIncludeMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addIncludeMeta(queryParams, this.includeMeta);
    }

    private void addIncludeMeta(Map<String, String> queryParams, boolean includeMeta) throws UnsupportedEncodingException {
        if (includeMeta) {
            queryParams.put("includeMeta", Boolean.toString(includeMeta));
        }
    }

    private void addOffset(Map<String, String> queryParams, Integer offset) throws UnsupportedEncodingException {
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
    }

    private void addLimit(Map<String, String> queryParams, Integer limit) throws UnsupportedEncodingException {
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void addHeader(String name, boolean value) {
        this.addHeader(name, Boolean.toString(value));
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
        Secret secret = SecretManagerProvider.get();
        Map authorizationHeaders = secret.getHTTPAuthorizationHeaders();
        for (String key : authorizationHeaders.keySet()) {
            gxHTTPStringRequest.header(key, (String)authorizationHeaders.get(key));
        }
        gxHTTPStringRequest.from(this.getClass().getSimpleName());
        for (String name : this.headers.keySet()) {
            gxHTTPStringRequest.header(name, this.headers.get(name));
        }
        return gxHTTPStringRequest;
    }

    public ResourceRegistryContextClientImpl(String address) {
        this.address = address;
        this.headers = new HashMap<String, String>();
        this.includeMeta = false;
        this.contextCache = new ContextCache();
        this.contextCache.setContextCacheRenewal(this.contextCacheRenewal);
    }

    private void forceCacheRefresh() {
        try {
            this.contextCache.cleanCache();
            this.contextCache.refreshContextsIfNeeded();
        }
        catch (Exception e) {
            logger.warn("Unable to force cache refresh.", (Throwable)e);
        }
    }

    public List<Context> getAllContextFromServer() throws ResourceRegistryException {
        return this.getAllContextFromServer(this.includeMeta, this.offset, this.limit);
    }

    protected List<Context> getAllContextFromServer(boolean includeMeta, Integer offset, Integer limit) throws ResourceRegistryException {
        try {
            logger.info("Going to read all {}s", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters, includeMeta);
            this.addOffset(parameters, offset);
            this.addLimit(parameters, limit);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String all = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got contexts are {}", (Object)"Context", (Object)all);
            return ElementMapper.unmarshalList(Context.class, (String)all);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> all() throws ResourceRegistryException {
        return this.contextCache.getContexts();
    }

    @Override
    public ContextCache getContextCache() {
        return this.contextCache;
    }

    protected String internalCreate(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            UUID uuid = context.getID();
            if (uuid == null) {
                uuid = UUIDManager.getInstance().generateValidUUID();
                context.setID(uuid);
            }
            String contextString = ElementMapper.marshal((Element)context);
            logger.trace("Going to create {}", (Object)contextString);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(contextString);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            this.forceCacheRefresh();
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context create(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            String res = this.internalCreate(context);
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            return this.internalCreate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean existFromServer(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(String uuid) throws ResourceRegistryException {
        return this.exist(UUID.fromString(uuid));
    }

    @Override
    public boolean exist(UUID uuid) throws ResourceRegistryException {
        try {
            this.read(uuid);
            return true;
        }
        catch (ContextNotFoundException e) {
            return false;
        }
    }

    @Override
    public Context read(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.read(context.getID());
    }

    @Override
    public Context read(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        Context context = this.contextCache.getContextByUUID(uuid);
        if (context == null) {
            String contextJson = this.readFromServer(uuid.toString());
            try {
                context = (Context)ElementMapper.unmarshal(Context.class, (String)contextJson);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.forceCacheRefresh();
            Context c = this.contextCache.getContextByUUID(context.getID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Context with UUID {} is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)uuid, (Object)context);
            }
        }
        return context;
    }

    @Override
    public Context readCurrentContext() throws ContextNotFoundException, ResourceRegistryException {
        String contextFullName = SecretManagerProvider.get().getContext();
        UUID uuid = this.contextCache.getUUIDByFullName(contextFullName);
        return this.read(uuid);
    }

    @Override
    public String read(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            return ElementMapper.marshal((Element)this.read(UUID.fromString(uuid)));
        }
        catch (ContextNotFoundException e) {
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    public String readFromServer(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} is {}", (Object)"Context", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String internalUpdate(Context context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String contextString = ElementMapper.marshal((Element)context);
            logger.trace("Going to update {}", (Object)contextString);
            UUID uuid = context.getID();
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(contextString);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            this.forceCacheRefresh();
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context update(Context context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String res = this.internalUpdate(context);
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            return this.internalUpdate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(context.getID());
    }

    @Override
    public boolean delete(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(uuid.toString());
    }

    @Override
    public boolean delete(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with UUID {} {}", new Object[]{"Context", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            boolean bl = deleted;
            return bl;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.forceCacheRefresh();
            }
            catch (Exception exception) {}
        }
    }

    protected String internalChangeState(UUID uuid, String context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to change state of {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(context);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} state successfully changed", (Object)"Context");
            String string = c;
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.forceCacheRefresh();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Context changeState(Context context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String contextString = ElementMapper.marshal((Element)context);
            UUID uuid = context.getID();
            logger.trace("Going to change the state of {} with name {} id {} to {}", new Object[]{"Context", context.getName(), uuid, context.getState()});
            contextString = this.internalChangeState(uuid, contextString);
            return (Context)ElementMapper.unmarshal(Context.class, (String)contextString);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String changeState(String context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            UUID uuid = c.getID();
            logger.trace("Going to change the state of {} with name {} id {} to {}", new Object[]{"Context", c.getName(), uuid, c.getState()});
            return this.internalChangeState(uuid, context);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context changeState(UUID uuid, ContextState state) throws ContextNotFoundException, ResourceRegistryException {
        try {
            ContextImpl context = new ContextImpl("TempContext");
            context.setID(uuid);
            context.setState(state.getState());
            logger.trace("Going to change the state of {} with UUID {} to {}", new Object[]{"Context", uuid, state});
            return this.changeState((Context)context);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String changeState(String uuid, String state) throws ContextNotFoundException, ResourceRegistryException {
        try {
            ContextState contextState;
            UUID contextUuid;
            try {
                contextUuid = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid UUID format: " + uuid, e);
            }
            try {
                contextState = ContextState.fromString((String)state);
                if (contextState == null) {
                    throw new IllegalArgumentException("Invalid state value");
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid state value: " + state + ". Valid states are: " + Arrays.toString(ContextState.values()), e);
            }
            logger.trace("Going to change the state of {} with UUID {} to {}", new Object[]{"Context", uuid, state});
            Context updatedContext = this.changeState(contextUuid, contextState);
            return ElementMapper.marshal((Element)updatedContext);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

