/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClientFactory;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientImpl
implements ResourceRegistryContextClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientImpl.class);
    protected final String address;
    protected ContextCacheRenewal contextCacheRenewal = new ContextCacheRenewal(){

        public List<Context> renew() throws ResourceRegistryException {
            return ResourceRegistryContextClientImpl.this.getAllContextFromServer();
        }
    };

    public ResourceRegistryContextClientImpl(String address) {
        this.address = address;
        ContextCache contextCache = ContextCache.getInstance();
        contextCache.setContextCacheRenewal(this.contextCacheRenewal);
    }

    private void forceCacheRefresh() {
        try {
            ContextCache contextCache = ContextCache.getInstance();
            contextCache.cleanCache();
            contextCache.refreshContextsIfNeeded();
        }
        catch (Exception e) {
            logger.warn("Unable to force cache refresh.", (Throwable)e);
        }
    }

    protected List<Context> getAllContextFromServer() throws ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String all = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got contexts are {}", (Object)"Context", (Object)all);
            return ElementMapper.unmarshalList(Context.class, (String)all);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> all() throws ResourceRegistryException {
        ContextCache contextCache = ContextCache.getInstance();
        return contextCache.getContexts();
    }

    protected String internalCreate(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Header header = context.getHeader();
            if (header == null) {
                header = new HeaderImpl(UUID.randomUUID());
                context.setHeader(header);
            }
            UUID uuid = context.getHeader().getUUID();
            String contextString = ElementMapper.marshal((Element)context);
            logger.trace("Going to create {}", (Object)contextString);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(contextString);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            this.forceCacheRefresh();
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context create(Context context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            String res = this.internalCreate(context);
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String context) throws ContextAlreadyPresentException, ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            return this.internalCreate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean existFromServer(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(String uuid) throws ResourceRegistryException {
        return this.exist(UUID.fromString(uuid));
    }

    @Override
    public boolean exist(UUID uuid) throws ResourceRegistryException {
        try {
            this.read(uuid);
            return true;
        }
        catch (ContextNotFoundException e) {
            return false;
        }
    }

    @Override
    public Context read(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.read(context.getHeader().getUUID());
    }

    @Override
    public Context read(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        ContextCache contextCache = ContextCache.getInstance();
        Context context = ContextCache.getInstance().getContextByUUID(uuid);
        if (context == null) {
            String contextJson = this.readFromServer(uuid.toString());
            try {
                context = (Context)ElementMapper.unmarshal(Context.class, (String)contextJson);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.forceCacheRefresh();
            Context c = contextCache.getContextByUUID(context.getHeader().getUUID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Context with UUID {} is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)uuid, (Object)context);
            }
        }
        return context;
    }

    @Override
    public Context readCurrentContext() throws ContextNotFoundException, ResourceRegistryException {
        String contextFullName = ResourceRegistryContextClientFactory.getCurrentContextFullName();
        ContextCache contextCache = ContextCache.getInstance();
        UUID uuid = contextCache.getUUIDByFullName(contextFullName);
        Context context = null;
        if (uuid == null) {
            String contextJson = this.readFromServer("CURRENT_CONTEXT");
            try {
                context = (Context)ElementMapper.unmarshal(Context.class, (String)contextJson);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            contextCache.cleanCache();
            contextCache.refreshContextsIfNeeded();
            Context c = contextCache.getContextByUUID(context.getHeader().getUUID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Current Context is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)contextFullName);
            }
        } else {
            context = contextCache.getContextByUUID(uuid);
        }
        return context;
    }

    @Override
    public String read(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            return ElementMapper.marshal((Element)this.read(UUID.fromString(uuid)));
        }
        catch (ContextNotFoundException e) {
            throw e;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    public String readFromServer(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} is {}", (Object)"Context", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String internalUpdate(Context context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String contextString = ElementMapper.marshal((Element)context);
            logger.trace("Going to update {}", (Object)contextString);
            UUID uuid = context.getHeader().getUUID();
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(contextString);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            this.forceCacheRefresh();
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context update(Context context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            String res = this.internalUpdate(context);
            return (Context)ElementMapper.unmarshal(Context.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String context) throws ContextNotFoundException, ResourceRegistryException {
        try {
            Context c = (Context)ElementMapper.unmarshal(Context.class, (String)context);
            return this.internalUpdate(c);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(Context context) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(context.getHeader().getUUID());
    }

    @Override
    public boolean delete(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        return this.delete(uuid.toString());
    }

    @Override
    public boolean delete(String uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)"Context", (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryContextClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with UUID {} {}", new Object[]{"Context", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            boolean bl = deleted;
            return bl;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ContextCache contextCache = ContextCache.getInstance();
                contextCache.cleanCache();
                contextCache.refreshContextsIfNeeded();
            }
            catch (Exception exception) {}
        }
    }
}

