/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.api.contexts;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextInformation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.tree.NodeInformation;
import org.gcube.informationsystem.tree.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextCache {
    private static Logger logger = LoggerFactory.getLogger(ContextCache.class);
    public static final long DEFAULT_EXPIRING_TIMEOUT = TimeUnit.HOURS.toMillis(6L);
    public static int expiringTimeout = (int)DEFAULT_EXPIRING_TIMEOUT;
    protected static ContextCache singleton;
    protected ContextCacheRenewal contextCacheRenewal;
    protected Calendar creationTime;
    protected Calendar expiringTime;
    protected List<Context> contexts;
    protected Map<UUID, Context> uuidToContext;
    protected Map<UUID, String> uuidToContextFullName;
    protected Map<String, UUID> contextFullNameToUUID;
    protected Tree<Context> contextsTree;
    protected boolean initialized;

    public static void setExpiringTimeout(int expiringTimeout) {
        ContextCache.expiringTimeout = expiringTimeout;
    }

    public static synchronized ContextCache getInstance() {
        if (singleton == null) {
            singleton = new ContextCache();
        }
        return singleton;
    }

    public ContextCache() {
        Calendar now = Calendar.getInstance();
        this.cleanCache(now);
        this.initialized = false;
    }

    public void cleanCache() {
        this.cleanCache(Calendar.getInstance());
    }

    protected void cleanCache(Calendar calendar) {
        this.contexts = new ArrayList<Context>();
        this.uuidToContext = new LinkedHashMap<UUID, Context>();
        this.uuidToContextFullName = new LinkedHashMap<UUID, String>();
        this.contextFullNameToUUID = new TreeMap<String, UUID>();
        this.contextsTree = new Tree((NodeInformation)new ContextInformation());
        this.contextsTree.setAllowMultipleInheritance(false);
        this.creationTime = Calendar.getInstance();
        this.creationTime.setTimeInMillis(calendar.getTimeInMillis());
        this.expiringTime = Calendar.getInstance();
        this.expiringTime.setTimeInMillis(calendar.getTimeInMillis());
        this.expiringTime.add(14, -1);
        this.expiringTime.add(14, expiringTimeout);
        this.initialized = false;
    }

    public void renew() throws ResourceRegistryException {
        this.cleanCache();
        this.refreshContextsIfNeeded();
    }

    public ContextCacheRenewal getContextCacheRenewal() {
        return this.contextCacheRenewal;
    }

    public void setContextCacheRenewal(ContextCacheRenewal contextCacheRenewal) {
        if (this.contextCacheRenewal == null) {
            this.contextCacheRenewal = contextCacheRenewal;
        }
    }

    public synchronized void refreshContextsIfNeeded() throws ResourceRegistryException {
        Calendar now = Calendar.getInstance();
        if ((now.after(this.expiringTime) || !this.initialized) && this.contextCacheRenewal != null) {
            try {
                List<Context> contexts = this.contextCacheRenewal.renew();
                this.setContexts(now, contexts);
                this.initialized = true;
            }
            catch (ResourceRegistryException e) {
                if (!this.initialized) {
                    logger.error("Unable to initialize Context Cache", (Throwable)e);
                    throw e;
                }
                logger.error("Unable to refresh Context Cache", (Throwable)e);
            }
        }
    }

    public synchronized List<Context> getContexts() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.contexts;
    }

    public void setContexts(List<Context> contexts) {
        Calendar now = Calendar.getInstance();
        this.setContexts(now, contexts);
    }

    protected void setContexts(Calendar calendar, List<Context> contexts) {
        ContextImpl context;
        UUID uuid;
        this.cleanCache(calendar);
        for (Context c : contexts) {
            uuid = c.getID();
            context = new ContextImpl(c.getName());
            context.setMetadata(c.getMetadata());
            context.setID(uuid);
            this.contexts.add((Context)context);
            this.uuidToContext.put(uuid, (Context)context);
        }
        for (Context c : contexts) {
            uuid = c.getID();
            context = this.uuidToContext.get(uuid);
            if (c.getParent() == null) continue;
            IsParentOf ipo = c.getParent();
            UUID parentUUID = ipo.getSource().getID();
            Context parent = this.uuidToContext.get(parentUUID);
            IsParentOfImpl isParentOf = new IsParentOfImpl(parent, (Context)context);
            isParentOf.setID(parentUUID);
            isParentOf.setMetadata(ipo.getMetadata());
            parent.addChild((IsParentOf)isParentOf);
            context.setParent((IsParentOf)isParentOf);
        }
        for (Context context2 : contexts) {
            uuid = context2.getID();
            String fullName = this.getContextFullName(context2);
            this.uuidToContextFullName.put(uuid, fullName);
            this.contextFullNameToUUID.put(fullName, uuid);
        }
        TreeSet<String> contextFullNames = new TreeSet<String>(this.contextFullNameToUUID.keySet());
        for (String contextFullName : contextFullNames) {
            UUID uuid2 = this.contextFullNameToUUID.get(contextFullName);
            Context context3 = this.uuidToContext.get(uuid2);
            this.contextsTree.addNode((Object)context3);
        }
    }

    protected String getContextFullName(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        IsParentOf ipo = context.getParent();
        if (ipo != null) {
            Context c = ipo.getSource();
            c = this.uuidToContext.get(c.getID());
            String parentFullName = this.getContextFullName(c);
            stringBuilder.append(parentFullName);
        }
        stringBuilder.append("/");
        stringBuilder.append(context.getName());
        return stringBuilder.toString();
    }

    public synchronized String getContextFullNameByUUID(UUID uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.uuidToContextFullName.get(uuid);
    }

    public synchronized String getContextFullNameByUUID(String uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.uuidToContextFullName.get(UUID.fromString(uuid));
    }

    public synchronized UUID getUUIDByFullName(String contextFullName) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.contextFullNameToUUID.get(contextFullName);
    }

    public synchronized Context getContextByUUID(UUID uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.uuidToContext.get(uuid);
    }

    public synchronized Context getContextByUUID(String uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.getContextByUUID(UUID.fromString(uuid));
    }

    public synchronized Context getContextByFullName(String contextFullName) throws ResourceRegistryException {
        UUID uuid = this.getUUIDByFullName(contextFullName);
        return this.getContextByUUID(uuid);
    }

    public synchronized Map<UUID, String> getUUIDToContextFullNameAssociation() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return new LinkedHashMap<UUID, String>(this.uuidToContextFullName);
    }

    public synchronized Map<String, UUID> getContextFullNameToUUIDAssociation() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return new TreeMap<String, UUID>(this.contextFullNameToUUID);
    }

    public Tree<Context> getContextsTree() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.contextsTree;
    }
}

