package org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationAvailableInAnotherContextException;

/**
 * The Class IsRelatedToAvailableInAnotherContextException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsRelatedToAvailableInAnotherContextException extends RelationAvailableInAnotherContextException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 8320730396137844754L;

	/**
	 * Instantiates a new checks if is related to available in another context exception.
	 *
	 * @param message the message
	 */
	public IsRelatedToAvailableInAnotherContextException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new checks if is related to available in another context exception.
	 *
	 * @param cause the cause
	 */
	public IsRelatedToAvailableInAnotherContextException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new checks if is related to available in another context exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public IsRelatedToAvailableInAnotherContextException(String message, Throwable cause) {
		super(message, cause);
	}

}
