package org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.EntityAvailableInAnotherContextException;

/**
 * The Class FacetAvailableInAnotherContextException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class FacetAvailableInAnotherContextException extends EntityAvailableInAnotherContextException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = -7502387344011649559L;

	/**
	 * Instantiates a new facet available in another context exception.
	 *
	 * @param message the message
	 */
	public FacetAvailableInAnotherContextException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new facet available in another context exception.
	 *
	 * @param cause the cause
	 */
	public FacetAvailableInAnotherContextException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new facet available in another context exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public FacetAvailableInAnotherContextException(String message, Throwable cause) {
		super(message, cause);
	}

}
