package org.gcube.informationsystem.resourceregistry.api.exceptions.types;



import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;

/**
 * The Class SchemaNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class SchemaNotFoundException extends NotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -1441446827386524456L;

	/**
	 * Instantiates a new schema not found exception.
	 *
	 * @param message the message
	 */
	public SchemaNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new schema not found exception.
	 *
	 * @param cause the cause
	 */
	public SchemaNotFoundException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new schema not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public SchemaNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}
	
}
