package org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto;



import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationCreationException;

/**
 * The Class IsRelatedToCreationException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsRelatedToCreationException extends RelationCreationException {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -310747999683731578L;

	/**
	 * Instantiates a new checks if is related to creation exception.
	 *
	 * @param message the message
	 */
	public IsRelatedToCreationException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new checks if is related to creation exception.
	 *
	 * @param cause the cause
	 */
	public IsRelatedToCreationException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new checks if is related to creation exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public IsRelatedToCreationException(String message, Throwable cause) {
		super(message, cause);
	}
}
