package org.gcube.informationsystem.resourceregistry.api.exceptions.types;



import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;

/**
 * The Class SchemaViolationException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class SchemaViolationException extends ResourceRegistryException {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -2563703637351710301L;

	/**
	 * Instantiates a new schema violation exception.
	 *
	 * @param message the message
	 */
	public SchemaViolationException(String message) {
		super(message);
	}
	
	/**
	 * Instantiates a new schema violation exception.
	 *
	 * @param cause the cause
	 */
	public SchemaViolationException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new schema violation exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public SchemaViolationException(String message, Throwable cause) {
		super(message, cause);
	}
}
