package org.gcube.informationsystem.resourceregistry.api.exceptions.queries;



import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;

/**
 * The Class InvalidQueryException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class InvalidQueryException extends ResourceRegistryException {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -5146082051190251441L;
	
	/**
	 * Instantiates a new invalid query exception.
	 *
	 * @param message the message
	 */
	public InvalidQueryException(String message) {
		super(message);
	}
	
	/**
	 * Instantiates a new invalid query exception.
	 *
	 * @param cause the cause
	 */
	public InvalidQueryException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new invalid query exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public InvalidQueryException(String message, Throwable cause) {
		super(message, cause);
	}
	
}
