package org.gcube.informationsystem.resourceregistry.api.utils;

import java.io.IOException;
import java.util.UUID;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.utils.ElementMapper;

public abstract class Utility {
	
	public static String getClassFromJsonNode(JsonNode jsonNode){
		return jsonNode.get(Element.CLASS_PROPERTY).asText();
	}
	
	public static String getClassFromJsonString(String json) throws JsonProcessingException, IOException{
		JsonNode jsonNode = ElementMapper.getObjectMapper().readTree(json);
		return getClassFromJsonNode(jsonNode);
	}
	
	public static String getUUIDStringFromJsonNode(JsonNode jsonNode){
		return jsonNode.get(IdentifiableElement.HEADER_PROPERTY).get(Element.CLASS_PROPERTY).asText();
	}
	public static UUID getUUIDFromJsonNode(JsonNode jsonNode){
		String uuidString = getUUIDStringFromJsonNode(jsonNode);
		return UUID.fromString(uuidString);
	}
	
	public static String getUUIDStringFromJsonString(String json) throws JsonProcessingException, IOException{
		JsonNode jsonNode = ElementMapper.getObjectMapper().readTree(json);
		return getUUIDStringFromJsonNode(jsonNode);
	}
	
	public static UUID getUUIDFromJsonString(String json) throws JsonProcessingException, IOException{
		JsonNode jsonNode = ElementMapper.getObjectMapper().readTree(json);
		return getUUIDFromJsonNode(jsonNode);
	}
	
	
	// TODO move somewhere else, probably in Element
	
	public static String getTypeName(Element element){
		return getTypeName(element.getClass());
	}
	
	public static <E extends Element> String getTypeName(Class<E> clz){
		if(!clz.isInterface()){
			return clz.getAnnotation(JsonTypeName.class).value();
		}else {
			return TypeMapper.getType(clz);
		}
	}
	
}
