/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resource_checker.beans;

import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.Software;
import org.gcube.informationsystem.resource_checker.beans.ContextLevel;
import org.gcube.informationsystem.resource_checker.beans.OperationLevel;

public class BasicFunctionalityBean {
    private String category;
    private String name;
    private Class type;
    private String resourceId;
    private OperationLevel opLevel = OperationLevel.ALERT_READD;
    private ContextLevel ctxLevel = ContextLevel.ALL;

    public BasicFunctionalityBean(String category, String name, String type, String opLevel, String ctxLevel) {
        this.category = category;
        this.name = name;
        if (type == null) {
            this.type = ServiceEndpoint.class;
        } else {
            Resource.Type extractedType = Resource.Type.valueOf((String)type);
            switch (extractedType) {
                case GCOREENDPOINT: {
                    this.type = GCoreEndpoint.class;
                    break;
                }
                case GENERIC: {
                    this.type = GenericResource.class;
                    break;
                }
                case NODE: {
                    this.type = HostingNode.class;
                    break;
                }
                case SOFTWARE: {
                    this.type = Software.class;
                    break;
                }
                default: {
                    this.type = ServiceEndpoint.class;
                }
            }
        }
        if (opLevel != null) {
            this.opLevel = OperationLevel.valueOf(opLevel);
        }
        if (ctxLevel != null) {
            this.ctxLevel = ContextLevel.valueOf(ctxLevel);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getType() {
        return this.type;
    }

    public void Class(Class type) {
        this.type = type;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public OperationLevel getOpLevel() {
        return this.opLevel;
    }

    public void setOpLevel(OperationLevel opLevel) {
        this.opLevel = opLevel;
    }

    public ContextLevel getCtxLevel() {
        return this.ctxLevel;
    }

    public void setCtxLevel(ContextLevel ctxLevel) {
        this.ctxLevel = ctxLevel;
    }

    public String toString() {
        return "BasicFunctionalityBean [category=" + this.category + ", name=" + this.name + ", type=" + this.type + ", resourceId=" + this.resourceId + ", opLevel=" + (Object)((Object)this.opLevel) + ", ctxLevel=" + (Object)((Object)this.ctxLevel) + "]";
    }
}

