/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resource_checker;

import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.Software;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.resource_checker.ResourceCheckerPluginDeclaration;
import org.gcube.informationsystem.resource_checker.beans.BasicFunctionalityBean;
import org.gcube.informationsystem.resource_checker.beans.ContextLevel;
import org.gcube.informationsystem.resource_checker.beans.OperationLevel;
import org.gcube.informationsystem.resource_checker.utils.BasicFunctionalitiesMandatoryReader;
import org.gcube.informationsystem.resource_checker.utils.RetrieveContextsList;
import org.gcube.informationsystem.resource_checker.utils.SendNotification;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ResourceCheckerPlugin
extends Plugin<ResourceCheckerPluginDeclaration> {
    private static final int SECONDS2WAIT = 2;
    private static final String INITIAL_ERRORS_STATEMENT = "Other errors: ";
    public static final String ROLE_TO_NOTIFY = "role";
    private static final String NAGIOS_PROPERTY_FILE = "/META-INF/plugin_resources/nagios-report-location.properties";
    private static final Logger logger = LoggerFactory.getLogger(ResourceCheckerPlugin.class);
    private static final DiscoveryClient client = ICFactory.client();

    public ResourceCheckerPlugin(ResourceCheckerPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.info("Constructor invoked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(Map<String, Object> inputs) throws Exception {
        String originalContext = ScopeProvider.instance.get();
        try {
            logger.info("Starting plugin with inputs: " + inputs);
            List<BasicFunctionalityBean> mandatoryFunctionalities = new BasicFunctionalitiesMandatoryReader().getMandatoryFunctionalities();
            List<String> contexts = RetrieveContextsList.getContexts();
            logger.info("Contexts are " + contexts);
            logger.info("Mandatory functionalities are " + mandatoryFunctionalities);
            HashMap<String, List<BasicFunctionalityBean>> missingResourcesPerContext = new HashMap<String, List<BasicFunctionalityBean>>(contexts.size());
            String otherFailures = INITIAL_ERRORS_STATEMENT;
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            HashSet<String> missingResourceIds = new HashSet<String>(mandatoryFunctionalities.size());
            HashMap<String, BasicFunctionalityBean> idToResource = new HashMap<String, BasicFunctionalityBean>(mandatoryFunctionalities.size());
            for (String context : contexts) {
                ScopeProvider.instance.set(context);
                for (BasicFunctionalityBean service : mandatoryFunctionalities) {
                    ScopeBean sb = new ScopeBean(context);
                    ContextLevel contextDepth = service.getCtxLevel();
                    if (contextDepth.equals((Object)ContextLevel.VO) && sb.type().equals((Object)ScopeBean.Type.VRE)) {
                        logger.info("Resource " + service + " doesn't need to be checked in a VRE context (" + context + ")");
                        continue;
                    }
                    try {
                        String resourceId = null;
                        resourceId = this.isServicePresent(service, client, docBuilder);
                        if (resourceId != null) {
                            service.setResourceId(resourceId);
                            idToResource.put(resourceId, service);
                        } else {
                            List<BasicFunctionalityBean> missingServices = missingResourcesPerContext.containsKey(context) ? (List)missingResourcesPerContext.get(context) : new ArrayList();
                            missingServices.add(service);
                            missingResourcesPerContext.put(context, missingServices);
                        }
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) continue;
                        logger.warn("An error arose when checking for resource " + service + " into context " + context);
                        otherFailures = otherFailures + "\nAn error arose while checking for resource with name/category " + service.getName() + "/" + service.getCategory() + " and type " + service.getType().getCanonicalName() + " into context " + context + "(stack trace is : " + e.getMessage() + ")";
                    }
                }
            }
            otherFailures = otherFailures.equals(INITIAL_ERRORS_STATEMENT) ? otherFailures + "none.\n" : otherFailures + "\n";
            this.evaluateMissingIds(missingResourceIds, missingResourcesPerContext);
            this.writeReport4Nagios(missingResourceIds);
            if (!missingResourceIds.isEmpty()) {
                logger.info("Going to perform add and alert or just alert of missing resources");
                otherFailures = "Re-add operation on some resources has been executed. This is the result:";
                for (String resId : missingResourceIds) {
                    if (((BasicFunctionalityBean)idToResource.get(resId)).getOpLevel().equals((Object)OperationLevel.ALERT)) {
                        logger.info("Resource " + idToResource.get(resId) + " doesn't need to be readded into the scopes it is missing");
                        continue;
                    }
                    try {
                        this.readdResource(contexts, resId, (BasicFunctionalityBean)idToResource.get(resId));
                        otherFailures = otherFailures + "\n -resource with identifier " + resId + " has been readded in the scopes it was missing;";
                    }
                    catch (Exception e) {
                        otherFailures = otherFailures + "\n -while trying to re-add the resource with the following identifier " + resId + " there was this error: " + e.getMessage() + ";";
                        logger.error("While readding a resource this error arose", (Throwable)e);
                    }
                }
            }
            if (!missingResourcesPerContext.isEmpty() || !otherFailures.equals("Other errors: none.\n")) {
                SendNotification.sendMessage(missingResourcesPerContext, otherFailures, (String)inputs.get(ROLE_TO_NOTIFY));
            }
            logger.info("Plugin's execution ended.");
        }
        catch (Exception e) {
            logger.error("The following error arose during the execution of the plugin", (Throwable)e);
        }
        finally {
            logger.debug("Resetting original scope in thread");
            ScopeProvider.instance.set(originalContext);
        }
    }

    private void evaluateMissingIds(Set<String> missingResourceIds, Map<String, List<BasicFunctionalityBean>> missingResourcesPerContext) {
        for (Map.Entry<String, List<BasicFunctionalityBean>> entry : missingResourcesPerContext.entrySet()) {
            List<BasicFunctionalityBean> missingResources = entry.getValue();
            for (BasicFunctionalityBean basicFunctionalityBean : missingResources) {
                missingResourceIds.add(basicFunctionalityBean.getResourceId());
            }
        }
    }

    private String isServicePresent(BasicFunctionalityBean service, DiscoveryClient client, DocumentBuilder docBuilder) throws Exception {
        Class classFor = service.getType() == null ? ServiceEndpoint.class : service.getType();
        XQuery q = ICFactory.queryFor((Class)classFor);
        List result = null;
        if (classFor.equals(ServiceEndpoint.class)) {
            q.addCondition("$resource/Profile/Name/text() eq '" + service.getName() + "'");
            q.addCondition("$resource/Profile/Category/text() eq '" + service.getCategory() + "'");
            result = client.submit((Query)q);
        } else if (classFor.equals(GCoreEndpoint.class)) {
            q.addCondition("$resource/Profile/ServiceName/text() eq '" + service.getName() + "'");
            q.addCondition("$resource/Profile/ServiceClass/text() eq '" + service.getCategory() + "'");
            result = client.submit((Query)q);
        } else {
            if (classFor.equals(GenericResource.class)) {
                logger.error("There is no implementation yet to check for GenericResource");
                throw new Exception("There is no implementation yet to check for GenericResource");
            }
            if (classFor.equals(HostingNode.class)) {
                logger.error("There is no implementation yet to check for HostingNode");
                throw new Exception("There is no implementation yet to check for HostingNode");
            }
            if (classFor.equals(Software.class)) {
                logger.error("There is no implementation yet to check for Software");
                throw new Exception("There is no implementation yet to check for Software");
            }
            throw new Exception("Unable to check resource because its type is missing " + service);
        }
        if (result == null || result.isEmpty()) {
            return null;
        }
        String elem = (String)result.get(0);
        Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
        XPathHelper helper = new XPathHelper((Node)node);
        List currValue = null;
        currValue = helper.evaluate("/Resource/ID/text()");
        if (currValue != null && currValue.size() > 0) {
            logger.debug("Id is " + (String)currValue.get(0));
            return (String)currValue.get(0);
        }
        throw new Exception("ID property is missing!");
    }

    private void writeReport4Nagios(Set<String> idsMissingResources) throws Exception {
        try {
            Properties prop = new Properties();
            prop.load(((Object)((Object)this)).getClass().getResourceAsStream(NAGIOS_PROPERTY_FILE));
            String location = prop.getProperty("location");
            logger.trace("File location for nagios is " + location);
            File f = new File(location);
            f.getParentFile().mkdirs();
            f.delete();
            f.createNewFile();
            FileWriter writer = new FileWriter(f, false);
            if (idsMissingResources == null || idsMissingResources.isEmpty()) {
                writer.write("none\n");
            } else {
                for (String idMissing : idsMissingResources) {
                    writer.write(idMissing + "\n");
                }
            }
            writer.close();
        }
        catch (Exception e) {
            logger.error("Failed to write the report file for nagios", (Throwable)e);
        }
    }

    private <T extends Resource> void readdResource(List<String> allScopes, String resourceId, BasicFunctionalityBean service) {
        logger.info("Adding back resource with id " + resourceId + "(" + service + ") to scopes " + allScopes);
        String currentScope = allScopes.get(0);
        ScopeProvider.instance.set(currentScope);
        XQuery query = ICFactory.queryFor((Class)service.getType());
        DiscoveryClient client = ICFactory.clientFor((Class)service.getType());
        query.addCondition("$resource/ID/text() = '" + resourceId + "'");
        Resource resource = (Resource)client.submit((Query)query).get(0);
        resource.scopes().asCollection().retainAll(Collections.emptyList());
        resource.scopes().asCollection().addAll(allScopes);
        RegistryPublisher pub = RegistryPublisherFactory.create();
        pub.vosUpdate(resource);
    }

    protected void onStop() throws Exception {
        Thread.currentThread().interrupt();
        logger.debug("onStop() invoked");
    }
}

