/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.exporter.mapper;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.informationsystem.exporter.mapper.GCoreResourceMapper;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.resourcemanagement.model.impl.entities.facets.SimpleFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.ConfigurationImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimpleFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.Configuration;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.json.JSONObject;
import org.json.XML;

public class GenericResourceExporter
extends GCoreResourceMapper<GenericResource, Configuration> {
    public static final String FIXED_VERSION = "1.0.0";
    public static final String FULL_BODY = "FULL_BODY";

    public GenericResourceExporter(Boolean filteredReport, Boolean statistics) {
        super(GenericResource.class, Configuration.class, filteredReport, statistics);
    }

    @Override
    protected Configuration map(GenericResource gr) throws Exception {
        GenericResource.Profile profile = gr.profile();
        UUID uuid = UUID.fromString(gr.id());
        boolean readFromIS = false;
        ConfigurationImpl configuration = null;
        SoftwareFacetImpl softwareFacet = null;
        SimpleFacet simpleFacet = null;
        try {
            readFromIS = this.resourceRegistryClient.existInstance(this.rClass, uuid);
        }
        catch (NotFoundException e) {
            readFromIS = false;
        }
        catch (AvailableInAnotherContextException e) {
            this.resourceRegistryPublisher.addResourceToCurrentContext("Configuration", uuid, Boolean.valueOf(false));
            Thread.sleep(100L);
            readFromIS = true;
        }
        if (readFromIS) {
            configuration = (Configuration)this.read(uuid);
            List consistsOfs = configuration.getConsistsOf();
            for (ConsistsOf c : consistsOfs) {
                Facet target = (Facet)c.getTarget();
                if (c instanceof IsIdentifiedBy && target instanceof SoftwareFacet) {
                    softwareFacet = (SoftwareFacet)target;
                    continue;
                }
                if (!(c instanceof ConsistsOf) || !(target instanceof SimpleFacet)) continue;
                simpleFacet = (SimpleFacet)target;
            }
        } else {
            configuration = new ConfigurationImpl();
            HeaderImpl header = new HeaderImpl(uuid);
            configuration.setHeader((Header)header);
        }
        if (softwareFacet == null) {
            softwareFacet = new SoftwareFacetImpl();
            IsIdentifiedByImpl identifiedBy = new IsIdentifiedByImpl((Resource)configuration, (Facet)softwareFacet, null);
            configuration.addFacet((ConsistsOf)identifiedBy);
        }
        softwareFacet.setGroup(profile.type());
        softwareFacet.setName(profile.name());
        softwareFacet.setVersion(FIXED_VERSION);
        String description = profile.description();
        if (description != null && description.compareTo("") != 0) {
            softwareFacet.setDescription(this.getStringAsUTF8(description));
        }
        String xmlBody = profile.bodyAsString();
        JSONObject jsonBody = XML.toJSONObject((String)this.getStringAsUTF8(xmlBody));
        Map map = jsonBody.toMap();
        if (simpleFacet == null) {
            simpleFacet = new SimpleFacetImpl();
            configuration.addFacet((Facet)simpleFacet);
            try {
                SimpleFacetImpl testSimpleFacet = new SimpleFacetImpl();
                testSimpleFacet.setAdditionalProperties(map);
                SimpleFacet created = (SimpleFacet)this.resourceRegistryPublisher.createFacet((Facet)testSimpleFacet);
                this.resourceRegistryPublisher.deleteFacet((Facet)created);
                simpleFacet.setAdditionalProperties(map);
            }
            catch (Exception e) {
                simpleFacet.setAdditionalProperty(FULL_BODY, (Object)this.getStringAsUTF8(xmlBody));
            }
        } else if (simpleFacet.getAdditionalProperty(FULL_BODY) != null) {
            simpleFacet.setAdditionalProperty(FULL_BODY, (Object)this.getStringAsUTF8(xmlBody));
        } else {
            simpleFacet.setAdditionalProperties(map);
        }
        return configuration;
    }
}

