/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.exporter.mapper;

import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.informationsystem.exporter.mapper.GCoreResourceMapper;
import org.gcube.informationsystem.model.impl.properties.EncryptedImpl;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.resourcemanagement.model.impl.entities.facets.AccessPointFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.NetworkingFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.ServiceStateFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.EServiceImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.AccessPointFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.NetworkingFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.ServiceStateFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEndpointExporter
extends GCoreResourceMapper<ServiceEndpoint, EService> {
    private static Logger logger = LoggerFactory.getLogger(ServiceEndpointExporter.class);
    public static final String FIXED_VERSION = "1.0.0";
    public static final String PLATFORM = "PLATFORM";
    public static final String POSITION = "POSITION";
    public static final String GHN_ID = "ghnID";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String ARRAY = "ARRAY";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String NOT_URI_ENDPOINT = "NOT_URI_ENDPOINT";

    public ServiceEndpointExporter(boolean filteredReport, Boolean statistics) {
        super(ServiceEndpoint.class, EService.class, filteredReport, statistics);
    }

    @Override
    protected EService map(ServiceEndpoint gr) throws Exception {
        ServiceEndpoint.Profile profile = gr.profile();
        UUID uuid = UUID.fromString(gr.id());
        boolean readFromIS = false;
        EServiceImpl eService = null;
        AccessPointFacet[] accessPointFacets = null;
        SoftwareFacetImpl softwareFacet = null;
        SoftwareFacetImpl platformSoftwareFacet = null;
        ServiceStateFacet serviceStateFacet = null;
        NetworkingFacet networkingFacet = null;
        try {
            readFromIS = this.resourceRegistryClient.exists(this.rClass, uuid);
        }
        catch (NotFoundException e) {
            readFromIS = false;
        }
        catch (AvailableInAnotherContextException e) {
            this.resourceRegistryPublisher.addResourceToCurrentContext("EService", uuid);
            Thread.sleep(100L);
            readFromIS = true;
        }
        Group accessPoints = profile.accessPoints();
        accessPointFacets = new AccessPointFacet[accessPoints.size()];
        if (readFromIS) {
            eService = (EService)this.read(uuid);
            List consistsOfs = eService.getConsistsOf();
            for (ConsistsOf c : consistsOfs) {
                Facet target = (Facet)c.getTarget();
                if (c instanceof IsIdentifiedBy) {
                    if (!(target instanceof SoftwareFacet)) continue;
                    softwareFacet = (SoftwareFacet)target;
                    continue;
                }
                if (target instanceof AccessPointFacet) {
                    try {
                        Object positionObject = c.getAdditionalProperty(POSITION);
                        Integer position = Integer.valueOf(positionObject.toString());
                        if (position == null) continue;
                        accessPointFacets[position.intValue()] = (AccessPointFacet)target;
                    }
                    catch (Exception e) {
                        logger.error("No POSITION found", (Throwable)e);
                    }
                    continue;
                }
                if (target instanceof SoftwareFacet) {
                    SoftwareFacet targetSoftwareFacet = (SoftwareFacet)target;
                    if (targetSoftwareFacet.getGroup().compareTo(PLATFORM) != 0) continue;
                    platformSoftwareFacet = targetSoftwareFacet;
                    continue;
                }
                if (target instanceof ServiceStateFacet) {
                    serviceStateFacet = (ServiceStateFacet)target;
                    continue;
                }
                if (!(target instanceof NetworkingFacet)) continue;
                networkingFacet = (NetworkingFacet)target;
            }
        } else {
            eService = new EServiceImpl();
            HeaderImpl header = new HeaderImpl(uuid);
            eService.setHeader((Header)header);
        }
        if (softwareFacet == null) {
            softwareFacet = new SoftwareFacetImpl();
            IsIdentifiedByImpl identifiedBy = new IsIdentifiedByImpl((Resource)eService, (Facet)softwareFacet, null);
            eService.addFacet((ConsistsOf)identifiedBy);
        }
        softwareFacet.setGroup(profile.category());
        softwareFacet.setName(profile.name());
        softwareFacet.setVersion(FIXED_VERSION);
        String description = profile.description();
        if (description != null && description.compareTo("") != 0) {
            softwareFacet.setDescription(this.getStringAsUTF8(description));
        }
        Platform platform = profile.platform();
        if (platformSoftwareFacet == null) {
            platformSoftwareFacet = new SoftwareFacetImpl();
            eService.addFacet((Facet)platformSoftwareFacet);
        }
        platformSoftwareFacet.setGroup(PLATFORM);
        platformSoftwareFacet.setName(platform.name());
        String platformVersion = String.format("%d.%d.%d-%d", platform.version(), platform.minorVersion(), platform.revisionVersion(), platform.buildVersion());
        softwareFacet.setVersion(platformVersion);
        ServiceEndpoint.Runtime runTime = profile.runtime();
        if (serviceStateFacet == null) {
            serviceStateFacet = new ServiceStateFacetImpl();
            eService.addFacet((Facet)serviceStateFacet);
        }
        serviceStateFacet.setValue(runTime.status());
        if (networkingFacet == null) {
            networkingFacet = new NetworkingFacetImpl();
            eService.addFacet((Facet)networkingFacet);
        }
        networkingFacet.setHostName(runTime.hostedOn());
        String ghnID = runTime.ghnId();
        if (ghnID != null && ghnID.compareTo("") != 0) {
            networkingFacet.setAdditionalProperty(GHN_ID, (Object)ghnID);
        }
        int i = 0;
        for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
            String accessPointDescription;
            if (accessPointFacets[i] == null) {
                accessPointFacets[i] = new AccessPointFacetImpl();
                ConsistsOfImpl consistsOf = new ConsistsOfImpl((Resource)eService, (Facet)accessPointFacets[i], null);
                consistsOf.setAdditionalProperty(POSITION, (Object)i);
                eService.addFacet((ConsistsOf)consistsOf);
            }
            accessPointFacets[i].setEntryName(accessPoint.name());
            String address = accessPoint.address();
            if (address != null && address.compareTo("") != 0) {
                try {
                    URI uri = URI.create(address);
                    accessPointFacets[i].setEndpoint(uri);
                }
                catch (IllegalArgumentException e) {
                    accessPointFacets[i].setAdditionalProperty(NOT_URI_ENDPOINT, (Object)address);
                }
            }
            if ((accessPointDescription = accessPoint.description()) != null && accessPointDescription.compareTo("") != 0) {
                accessPointFacets[i].setDescription(this.getStringAsUTF8(accessPointDescription));
            }
            try {
                String username = accessPoint.username();
                String passwordString = accessPoint.password();
                EncryptedImpl password = new EncryptedImpl();
                password.setEncryptedValue(passwordString);
                accessPointFacets[i].setAdditionalProperty(USERNAME, (Object)username);
                accessPointFacets[i].setAdditionalProperty(PASSWORD, (Object)password);
            }
            catch (NullPointerException username) {
                // empty catch block
            }
            Group properties = accessPoint.properties();
            if (properties != null && properties.size() > 0) {
                for (ServiceEndpoint.Property property : properties) {
                    String name = property.name();
                    boolean encryptedValue = property.isEncrypted();
                    if (encryptedValue) {
                        EncryptedImpl encrypted = new EncryptedImpl();
                        encrypted.setEncryptedValue(property.value());
                        accessPointFacets[i].setAdditionalProperty(name, (Object)encryptedValue);
                        continue;
                    }
                    accessPointFacets[i].setAdditionalProperty(name, (Object)property.value());
                }
            }
            ++i;
        }
        return eService;
    }
}

