/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.net.HttpURLConnection;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherImpl
implements ResourceRegistryPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherImpl.class);
    protected final String address;

    public ResourceRegistryPublisherImpl(String address) {
        this.address = address;
    }

    private static String getCurrentContext() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    private UUID getCurrentContextUUID() throws ResourceRegistryException {
        logger.debug("Going to read current {} ({}) definition", (Object)"Context", (Object)ResourceRegistryPublisherImpl.getCurrentContext());
        try {
            logger.info("Going to get current {} ", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path("CURRENT_CONTEXT");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            Context context = (Context)HTTPUtility.getResponse(Context.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Context is {}", (Object)ElementMapper.marshal((Element)context));
            return context.getHeader().getUUID();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String create(String identifiableElementTypeName, String json, UUID uuid) throws AlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create {} : {}", (Object)identifiableElementTypeName, (Object)json);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(identifiableElementTypeName);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(json);
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <IE extends IdentifiableElement> String internalCreate(IE identifiableElement) throws AlreadyPresentException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getTypeName(identifiableElement);
            String json = ElementMapper.marshal(identifiableElement);
            Header header = identifiableElement.getHeader();
            if (header == null) {
                header = new HeaderImpl(UUID.randomUUID());
                identifiableElement.setHeader(header);
            }
            UUID uuid = identifiableElement.getHeader().getUUID();
            return this.create(identifiableElementTypeName, json, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> IE create(IE identifiableElement) throws AlreadyPresentException, ResourceRegistryException {
        try {
            String ret = this.internalCreate(identifiableElement);
            return (IE)((IdentifiableElement)ElementMapper.unmarshal(IdentifiableElement.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String identifiableElement) throws AlreadyPresentException, ResourceRegistryException {
        try {
            IdentifiableElement e = (IdentifiableElement)ElementMapper.unmarshal(IdentifiableElement.class, (String)identifiableElement);
            return this.internalCreate(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> IE read(IE identifiableElement) throws NotFoundException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getTypeName(identifiableElement);
            UUID uuid = identifiableElement.getHeader().getUUID();
            String ret = this.read(identifiableElementTypeName, uuid);
            return (IE)((IdentifiableElement)ElementMapper.unmarshal(IdentifiableElement.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String identifiableElementTypeName, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)identifiableElementTypeName, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(identifiableElementTypeName);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} with UUID {} is {}", new Object[]{identifiableElementTypeName, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String update(String identifiableElementTypeName, String json, UUID uuid) throws AlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create {} : {}", (Object)identifiableElementTypeName, (Object)json);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(identifiableElementTypeName);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(json);
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} with UUID {} successfully created : {}", new Object[]{identifiableElementTypeName, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> IE update(IE identifiableElement) throws NotFoundException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getTypeName(identifiableElement);
            String json = ElementMapper.marshal(identifiableElement);
            UUID uuid = identifiableElement.getHeader().getUUID();
            String ret = this.update(identifiableElementTypeName, json, uuid);
            return (IE)((IdentifiableElement)ElementMapper.unmarshal(Element.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String identifiableElementTypeName, String json) throws NotFoundException, ResourceRegistryException {
        try {
            UUID uuid = org.gcube.informationsystem.utils.Utility.getUUIDFromJSONString((String)json);
            return this.update(identifiableElementTypeName, json, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String json) throws NotFoundException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getClassFromJsonString((String)json);
            return this.update(identifiableElementTypeName, json);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> boolean delete(IE identifiableElement) throws NotFoundException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getTypeName(identifiableElement);
            UUID uuid = identifiableElement.getHeader().getUUID();
            return this.delete(identifiableElementTypeName, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String identifiableElementTypeName, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)identifiableElementTypeName, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(identifiableElementTypeName);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with UUID {} {}", new Object[]{identifiableElementTypeName, uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> F createFacet(F facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        return this.create((IdentifiableElement)facet);
    }

    @Override
    public String createFacet(String facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        return this.create(facet);
    }

    @Override
    public <F extends Facet> F readFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.read((IdentifiableElement)facet);
    }

    @Override
    public String readFacet(String facetTypeName, UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.read(facetTypeName, uuid);
    }

    @Override
    public <F extends Facet> F updateFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.update((IdentifiableElement)facet);
    }

    @Override
    public String updateFacet(String facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.update(facet);
    }

    @Override
    public <F extends Facet> boolean deleteFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.delete((IdentifiableElement)facet);
    }

    @Override
    public boolean deleteFacet(String facetTypeName, UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.delete(facetTypeName, uuid);
    }

    @Override
    public <R extends Resource> R createResource(R resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        return this.create((IdentifiableElement)resource);
    }

    @Override
    public String createResource(String resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        return this.create(resource);
    }

    @Override
    public <R extends Resource> R readResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.read((IdentifiableElement)resource);
    }

    @Override
    public String readResource(String resourceTypeName, UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        return this.read(resourceTypeName, uuid);
    }

    @Override
    public <R extends Resource> R updateResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.update((IdentifiableElement)resource);
    }

    @Override
    public String updateResource(String resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.update(resource);
    }

    @Override
    public <R extends Resource> boolean deleteResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.delete((IdentifiableElement)resource);
    }

    @Override
    public boolean deleteResource(String resourceTypeName, UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        return this.delete(resourceTypeName, uuid);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.create((IdentifiableElement)consistsOf);
    }

    @Override
    public String createConsistsOf(String consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.create(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C readConsistsOf(C consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.read((IdentifiableElement)consistsOf);
    }

    @Override
    public String readConsistsOf(String consistsOfTypeName, UUID uuid) throws NotFoundException, ResourceRegistryException {
        return this.read(consistsOfTypeName, uuid);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C updateConsistsOf(C consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.update((IdentifiableElement)consistsOf);
    }

    @Override
    public String updateConsistsOf(String consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.update(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C consistsOf) throws ResourceRegistryException {
        return this.delete((IdentifiableElement)consistsOf);
    }

    @Override
    public boolean deleteConsistsOf(String consistsOfTypeName, UUID uuid) throws ResourceRegistryException {
        return this.delete(consistsOfTypeName, uuid);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        return this.create((IdentifiableElement)isRelatedTo);
    }

    @Override
    public String createIsRelatedTo(String isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        return this.create(isRelatedTo);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I readIsRelatedTo(I isRelatedTo) throws NotFoundException, ResourceRegistryException {
        return this.read((IdentifiableElement)isRelatedTo);
    }

    @Override
    public String readIsRelatedTo(String isRelatedToTypeName, UUID uuid) throws NotFoundException, ResourceRegistryException {
        return this.read(isRelatedToTypeName, uuid);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I updateIsRelatedTo(I isRelatedTo) throws NotFoundException, ResourceRegistryException {
        return this.update((IdentifiableElement)isRelatedTo);
    }

    @Override
    public String updateIsRelatedTo(String isRelatedTo) throws NotFoundException, ResourceRegistryException {
        return this.update(isRelatedTo);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I isRelatedTo) throws ResourceRegistryException {
        return this.delete((IdentifiableElement)isRelatedTo);
    }

    @Override
    public boolean deleteIsRelatedTo(String isRelatedToTypeName, UUID uuid) throws ResourceRegistryException {
        return this.delete(isRelatedToTypeName, uuid);
    }

    @Override
    public boolean addToContext(UUID contextUUID, String identifiableElementTypeName, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to add {} with UUID {} to {} with UUID {} ", new Object[]{identifiableElementTypeName, instanceUUID, "Context", contextUUID});
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.path("sharing");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(contextUUID.toString());
            gxHTTPStringRequest.path(identifiableElementTypeName);
            gxHTTPStringRequest.path(instanceUUID.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put();
            boolean added = (Boolean)HTTPUtility.getResponse(Boolean.class, (HttpURLConnection)httpURLConnection);
            logger.info("{} with UUID {} {} to {} with UUID {}", new Object[]{identifiableElementTypeName, instanceUUID, added ? " successfully added" : "was NOT added", "Context", contextUUID});
            return added;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> boolean addToContext(UUID contextUUID, IE identifiableElement) throws NotFoundException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getTypeName(identifiableElement);
            UUID instanceUUID = identifiableElement.getHeader().getUUID();
            return this.addToContext(contextUUID, identifiableElementTypeName, instanceUUID);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addToCurrentContext(String identifiableElementTypeName, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.addToContext(contextUUID, identifiableElementTypeName, instanceUUID);
    }

    @Override
    public <IE extends IdentifiableElement> boolean addToCurrentContext(IE identifiableElement) throws NotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.addToContext(contextUUID, identifiableElement);
    }

    @Override
    public boolean removeFromContext(UUID contextUUID, String identifiableElementTypeName, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to add {} with UUID {} to {} with UUID {} ", new Object[]{identifiableElementTypeName, instanceUUID, "Context", contextUUID});
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.path("sharing");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(contextUUID.toString());
            gxHTTPStringRequest.path(identifiableElementTypeName);
            gxHTTPStringRequest.path(instanceUUID.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            boolean removed = (Boolean)HTTPUtility.getResponse(Boolean.class, (HttpURLConnection)httpURLConnection);
            logger.info("{} with UUID {} {} to {} with UUID {}", new Object[]{identifiableElementTypeName, instanceUUID, removed ? " successfully removed" : "was NOT removed", "Context", contextUUID});
            return removed;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> boolean removeFromContext(UUID contextUUID, IE identifiableElement) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            String identifiableElementTypeName = Utility.getTypeName(identifiableElement);
            UUID instanceUUID = identifiableElement.getHeader().getUUID();
            return this.removeFromContext(contextUUID, identifiableElementTypeName, instanceUUID);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeFromCurrentContext(String identifiableElementTypeName, UUID instanceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.removeFromContext(contextUUID, identifiableElementTypeName, instanceUUID);
    }

    @Override
    public <IE extends IdentifiableElement> boolean removeFromCurrentContext(IE identifiableElement) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.removeFromContext(contextUUID, identifiableElement);
    }

    @Override
    public boolean addResourceToContext(UUID contextUUID, String resourceTypeName, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, resourceTypeName, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean addResourceToContext(UUID contextUUID, R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, (IdentifiableElement)resource);
    }

    @Override
    public boolean addResourceToCurrentContext(String resourceTypeName, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext(resourceTypeName, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean addResourceToCurrentContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext((IdentifiableElement)resource);
    }

    @Override
    public boolean removeResourceFromContext(UUID contextUUID, String resourceTypeName, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, resourceTypeName, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean removeResourceFromContext(UUID contextUUID, R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, (IdentifiableElement)resource);
    }

    @Override
    public boolean removeResourceFromCurrentContext(String resourceTypeName, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext(resourceTypeName, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean removeResourceFromCurrentContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext((IdentifiableElement)resource);
    }

    @Override
    public boolean addFacetToContext(UUID contextUUID, String facetTypeName, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, facetTypeName, facetUUID);
    }

    @Override
    public <F extends Facet> boolean addFacetToContext(UUID contextUUID, F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, (IdentifiableElement)facet);
    }

    @Override
    public boolean addFacetToCurrentContext(String facetTypeName, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext(facetTypeName, facetUUID);
    }

    @Override
    public <F extends Facet> boolean addFacetToCurrentContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext((IdentifiableElement)facet);
    }

    @Override
    public boolean removeFacetFromContext(UUID contextUUID, String facetTypeName, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, facetTypeName, facetUUID);
    }

    @Override
    public <F extends Facet> boolean removeFacetFromContext(UUID contextUUID, F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, (IdentifiableElement)facet);
    }

    @Override
    public boolean removeFacetFromCurrentContext(String facetTypeName, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext(facetTypeName, facetUUID);
    }

    @Override
    public <F extends Facet> boolean removeFacetFromCurrentContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext((IdentifiableElement)facet);
    }
}

