/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.exporter.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.informationsystem.exporter.mapper.GCoreResourceMapper;
import org.gcube.informationsystem.impl.embedded.HeaderImpl;
import org.gcube.informationsystem.impl.embedded.ValueSchemaImpl;
import org.gcube.informationsystem.impl.entity.facet.AccessPointFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.NetworkingFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.ServiceStateFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.SoftwareFacetImpl;
import org.gcube.informationsystem.impl.entity.resource.EServiceImpl;
import org.gcube.informationsystem.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.impl.relation.IsIdentifiedByImpl;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.embedded.ValueSchema;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.entity.facet.AccessPointFacet;
import org.gcube.informationsystem.model.entity.facet.NetworkingFacet;
import org.gcube.informationsystem.model.entity.facet.ServiceStateFacet;
import org.gcube.informationsystem.model.entity.facet.SoftwareFacet;
import org.gcube.informationsystem.model.entity.resource.EService;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsIdentifiedBy;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceEndpointExporter
extends GCoreResourceMapper<ServiceEndpoint, EService> {
    private static Logger logger = LoggerFactory.getLogger(ServiceEndpointExporter.class);
    public static final String FIXED_VERSION = "1.0.0";
    public static final String PLATFORM = "PLATFORM";
    public static final String POSITION = "POSITION";
    public static final String GHN_ID = "ghnID";
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    public static final String USERNAME_PASSWORD_SCHEMA_STRING = String.format("%s:%s", "USERNAME", "PASSWORD");
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String ENCRYPTED = "encrypted";
    public static final String ARRAY = "ARRAY";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String NOT_URI_ENDPOINT = "NOT_URI_ENDPOINT";

    public ServiceEndpointExporter(boolean filteredReport) {
        super(ServiceEndpoint.class, EService.class, filteredReport);
    }

    @Override
    protected EService map(ServiceEndpoint gr) throws Exception {
        ServiceEndpoint.Profile profile = gr.profile();
        UUID uuid = UUID.fromString(gr.id());
        boolean readFromIS = false;
        EServiceImpl eService = null;
        AccessPointFacet[] accessPointFacets = null;
        SoftwareFacetImpl softwareFacet = null;
        SoftwareFacetImpl platformSoftwareFacet = null;
        ServiceStateFacet serviceStateFacet = null;
        NetworkingFacet networkingFacet = null;
        try {
            this.resourceRegistryClient.exists(this.rClass, uuid);
            readFromIS = true;
        }
        catch (ResourceNotFoundException e) {
            readFromIS = false;
        }
        catch (ResourceAvailableInAnotherContextException e) {
            this.resourceRegistryPublisher.addResourceToContext(uuid);
            Thread.sleep(100L);
            readFromIS = true;
        }
        Group accessPoints = profile.accessPoints();
        accessPointFacets = new AccessPointFacet[accessPoints.size()];
        if (readFromIS) {
            eService = (EService)this.read(uuid);
            List consistsOfs = eService.getConsistsOf();
            for (ConsistsOf c : consistsOfs) {
                Facet target = (Facet)c.getTarget();
                if (c instanceof IsIdentifiedBy) {
                    if (!(target instanceof SoftwareFacet)) continue;
                    softwareFacet = (SoftwareFacet)target;
                    continue;
                }
                if (target instanceof AccessPointFacet) {
                    try {
                        Object positionObject = c.getAdditionalProperty(POSITION);
                        Integer position = Integer.valueOf(positionObject.toString());
                        if (position == null) continue;
                        accessPointFacets[position.intValue()] = (AccessPointFacet)target;
                    }
                    catch (Exception e) {
                        logger.error("No POSITION found", (Throwable)e);
                    }
                    continue;
                }
                if (target instanceof SoftwareFacet) {
                    SoftwareFacet targetSoftwareFacet = (SoftwareFacet)target;
                    if (targetSoftwareFacet.getGroup().compareTo(PLATFORM) != 0) continue;
                    platformSoftwareFacet = targetSoftwareFacet;
                    continue;
                }
                if (target instanceof ServiceStateFacet) {
                    serviceStateFacet = (ServiceStateFacet)target;
                    continue;
                }
                if (!(target instanceof NetworkingFacet)) continue;
                networkingFacet = (NetworkingFacet)target;
            }
        } else {
            eService = new EServiceImpl();
            HeaderImpl header = new HeaderImpl(uuid);
            eService.setHeader((Header)header);
        }
        if (softwareFacet == null) {
            softwareFacet = new SoftwareFacetImpl();
            IsIdentifiedByImpl identifiedBy = new IsIdentifiedByImpl((Resource)eService, (Facet)softwareFacet, null);
            eService.addFacet((ConsistsOf)identifiedBy);
        }
        softwareFacet.setGroup(profile.category());
        softwareFacet.setName(profile.name());
        softwareFacet.setVersion(FIXED_VERSION);
        String description = profile.description();
        if (description != null && description.compareTo("") != 0) {
            softwareFacet.setDescription(this.getStringAsUTF8(description));
        }
        Platform platform = profile.platform();
        if (platformSoftwareFacet == null) {
            platformSoftwareFacet = new SoftwareFacetImpl();
            eService.addFacet((Facet)platformSoftwareFacet);
        }
        platformSoftwareFacet.setGroup(PLATFORM);
        platformSoftwareFacet.setName(platform.name());
        String platformVersion = String.format("%d.%d.%d-%d", platform.version(), platform.minorVersion(), platform.revisionVersion(), platform.buildVersion());
        softwareFacet.setVersion(platformVersion);
        ServiceEndpoint.Runtime runTime = profile.runtime();
        if (serviceStateFacet == null) {
            serviceStateFacet = new ServiceStateFacetImpl();
            eService.addFacet((Facet)serviceStateFacet);
        }
        serviceStateFacet.setValue(runTime.status());
        if (networkingFacet == null) {
            networkingFacet = new NetworkingFacetImpl();
            eService.addFacet((Facet)networkingFacet);
        }
        networkingFacet.setHostName(runTime.hostedOn());
        String ghnID = runTime.ghnId();
        if (ghnID != null && ghnID.compareTo("") != 0) {
            networkingFacet.setAdditionalProperty(GHN_ID, (Object)ghnID);
        }
        int i = 0;
        for (ServiceEndpoint.AccessPoint accessPoint : accessPoints) {
            Group properties;
            String accessPointDescription;
            if (accessPointFacets[i] == null) {
                accessPointFacets[i] = new AccessPointFacetImpl();
                ConsistsOfImpl consistsOf = new ConsistsOfImpl((Resource)eService, (Facet)accessPointFacets[i], null);
                consistsOf.setAdditionalProperty(POSITION, (Object)i);
                eService.addFacet((ConsistsOf)consistsOf);
            }
            accessPointFacets[i].setEntryName(accessPoint.name());
            String address = accessPoint.address();
            if (address != null && address.compareTo("") != 0) {
                try {
                    URI uri = URI.create(address);
                    accessPointFacets[i].setEndpoint(uri);
                }
                catch (IllegalArgumentException e) {
                    accessPointFacets[i].setAdditionalProperty(NOT_URI_ENDPOINT, (Object)address);
                }
            }
            if ((accessPointDescription = accessPoint.description()) != null && accessPointDescription.compareTo("") != 0) {
                accessPointFacets[i].setDescription(this.getStringAsUTF8(accessPointDescription));
            }
            ValueSchemaImpl authorization = new ValueSchemaImpl();
            String value = USERNAME_PASSWORD_SCHEMA_STRING;
            String schema = USERNAME_PASSWORD_SCHEMA_STRING;
            boolean replaceColon = false;
            try {
                value = value.replace(USERNAME, accessPoint.username());
            }
            catch (NullPointerException e) {
                value = value.replace(USERNAME, "");
                schema = schema.replace(USERNAME, "");
                replaceColon = true;
            }
            try {
                value = value.replace(PASSWORD, accessPoint.password());
            }
            catch (NullPointerException e) {
                value = value.replace(PASSWORD, "");
                schema = schema.replace(PASSWORD, "");
                replaceColon = true;
            }
            if (replaceColon) {
                value = value.replace(":", "");
                schema = schema.replace(":", "");
            }
            if (value.compareTo("") != 0) {
                authorization.setValue(value);
                authorization.setSchema(URI.create(schema));
                accessPointFacets[i].setAuthorization((ValueSchema)authorization);
            }
            if ((properties = accessPoint.properties()) != null && properties.size() > 0) {
                ObjectNode propertiesObjectNode = ISMapper.getObjectMapper().createObjectNode();
                ArrayNode arrayNode = propertiesObjectNode.putArray(ARRAY);
                for (ServiceEndpoint.Property property : properties) {
                    ObjectNode objectNode = ISMapper.getObjectMapper().createObjectNode();
                    objectNode.put(NAME, property.name());
                    objectNode.put(VALUE, property.value());
                    objectNode.put(ENCRYPTED, Boolean.toString(property.isEncrypted()));
                    arrayNode.add((JsonNode)objectNode);
                }
                accessPointFacets[i].setAdditionalProperty(PROPERTIES, (Object)propertiesObjectNode);
            }
            ++i;
        }
        return eService;
    }
}

