/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.exporter.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.exporter.mapper.exception.CreateException;
import org.gcube.informationsystem.exporter.mapper.exception.UpdateException;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.ISManageable;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GCoreResourceMapper<GR extends org.gcube.common.resources.gcore.Resource, R extends Resource> {
    private static Logger logger = LoggerFactory.getLogger(GCoreResourceMapper.class);
    public static final String EXPORTED = "EXPORTED";
    public static final String EXPORTED_FROM_OLD_GCORE_IS = "EXPORTED_FROM_OLD_GCORE_IS";
    public static final String MAPPING_ERROR = "mapping";
    public static final String PUBLISHING_ERROR = "publishing";
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String ERROR = "error";
    public static final String DATE = "date";
    public static final String EXCEPTION_TYPE = "exceptionType";
    public static final String CREATE = "create";
    public static final String UPDATE = "update";
    protected final Class<GR> grClass;
    protected final Class<R> rClass;
    protected final boolean filteredReport;
    public static final String UTF8 = "UTF-8";
    protected ResourceRegistryPublisher resourceRegistryPublisher;
    protected ResourceRegistryClient resourceRegistryClient;

    public static String getCurrentContextName() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public static String getDateString(Calendar calendar) {
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        return format.format(date);
    }

    public File getFile(Class<?> grClass, String contextFullName, String dateString) {
        return new File(contextFullName.replace("/", "_") + "-" + grClass.getSimpleName() + "-" + dateString + "-exporter.json");
    }

    protected GCoreResourceMapper(Class<GR> grClass, Class<R> rClass, boolean filteredReport) {
        this.grClass = grClass;
        this.rClass = rClass;
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
        this.resourceRegistryClient = ResourceRegistryClientFactory.create();
        this.filteredReport = filteredReport;
    }

    protected List<GR> getAll() {
        XQuery query = ICFactory.queryFor(this.grClass);
        DiscoveryClient client = ICFactory.clientFor(this.grClass);
        return client.submit((Query)query);
    }

    protected String getStringAsUTF8(String s) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes("ISO-8859-1");
        return new String(bytes, UTF8);
    }

    protected R create(R r) throws ResourceRegistryException {
        return (R)this.resourceRegistryPublisher.createResource(this.rClass, r);
    }

    protected R update(R r) throws ResourceRegistryException {
        return (R)this.resourceRegistryPublisher.updateResource(this.rClass, r);
    }

    protected R read(UUID uuid) throws ResourceRegistryException {
        return (R)((Resource)this.resourceRegistryClient.getInstance(this.rClass, uuid));
    }

    protected R createOrUpdate(R r) throws ResourceRegistryException {
        UUID uuid = r.getHeader().getUUID();
        boolean update = false;
        try {
            this.resourceRegistryClient.exists(this.rClass, uuid);
            update = true;
        }
        catch (ResourceNotFoundException e) {
            update = false;
        }
        catch (ResourceAvailableInAnotherContextException e) {
            this.resourceRegistryPublisher.addResourceToContext(uuid);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            update = true;
        }
        if (update) {
            logger.debug("Resource with UUID {} exist. It will be updated", (Object)uuid);
            try {
                return this.update(r);
            }
            catch (ResourceRegistryException e) {
                throw new UpdateException(e);
            }
        }
        logger.debug("Resource with UUID {} does not exist. It will be created", (Object)uuid);
        try {
            return this.create(r);
        }
        catch (ResourceRegistryException e) {
            throw new CreateException(e);
        }
    }

    private ObjectNode addNodeToArray(ArrayNode arrayNode, ObjectMapper objectMapper, GR gr, Exception e) {
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put(TYPE, this.grClass.getSimpleName());
        objectNode.put(ID, gr.id());
        objectNode.put(ERROR, e.getMessage());
        arrayNode.add((JsonNode)objectNode);
        return objectNode;
    }

    protected String getUsername() throws Exception {
        String token = SecurityTokenProvider.instance.get();
        return Constants.authorizationService().get(token).getClientInfo().getId();
    }

    protected abstract R map(GR var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFailures(int allSize, List<GR> failed) {
        String contextName = GCoreResourceMapper.getCurrentContextName();
        if (failed.size() == 0) {
            logger.debug("No needs to create an empty report besause there were no exporting failures on {}", (Object)contextName);
            return;
        }
        logger.warn("-------------------------------------------------------");
        logger.warn("{} : {} of {} ({} failures) {}s were exported as {}s", new Object[]{contextName, allSize - failed.size(), allSize, failed.size(), this.grClass.getSimpleName(), this.rClass.getSimpleName()});
        logger.warn("-------------------------------------------------------\n\n");
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        Calendar calendar = Calendar.getInstance();
        String dateString = GCoreResourceMapper.getDateString(calendar);
        objectNode.put(DATE, dateString);
        ObjectNode context = objectNode.putObject(contextName);
        ArrayNode mappingArrayNode = context.putArray(MAPPING_ERROR);
        ArrayNode publishingArrayNode = context.putArray(PUBLISHING_ERROR);
        for (org.gcube.common.resources.gcore.Resource gr : failed) {
            logger.trace("-------------------------------------------------------");
            if (this.filteredReport) {
                try {
                    UUID.fromString(gr.id());
                }
                catch (Exception e) {
                    logger.debug("{} with has id {} which is not a valid UUID. The reports are filtered and such an error is not reported.", (Object)gr.getClass().getSimpleName(), (Object)gr.id());
                    continue;
                }
            }
            ISManageable r = null;
            try {
                r = (ISManageable)this.map(gr);
            }
            catch (Exception e) {
                this.addNodeToArray(mappingArrayNode, objectMapper, gr, e);
                logger.trace("Error exporting {}. The problem was on mapping {} with UUID {}", new Object[]{gr, this.grClass.getSimpleName(), gr.id()});
                logger.trace("-------------------------------------------------------\n");
                continue;
            }
            try {
                this.createOrUpdate(r);
            }
            catch (Exception e) {
                if (e.getCause() instanceof NullPointerException) {
                    logger.error("This MUST BE A BUG. Please Investigate");
                }
                if (e.getMessage().contains("com.orientechnologies.orient.server.distributed.task.ODistributedOperationException")) {
                    logger.error("This is an OrientDB distributed Issue");
                }
                ObjectNode node = this.addNodeToArray(publishingArrayNode, objectMapper, gr, e);
                if (e instanceof CreateException) {
                    node.put(EXCEPTION_TYPE, CREATE);
                }
                if (e instanceof UpdateException) {
                    node.put(EXCEPTION_TYPE, UPDATE);
                }
                try {
                    logger.trace("Error exporting {}. The problem was on publishing {} as {}", new Object[]{gr, this.rClass.getSimpleName(), ISMapper.marshal(r)});
                }
                catch (JsonProcessingException e1) {
                    logger.trace("", (Throwable)e1);
                }
            }
            logger.trace("-------------------------------------------------------\n");
        }
        if (this.filteredReport && mappingArrayNode.size() == 0 && publishingArrayNode.size() == 0) {
            logger.debug("No need to produce JSON reports because alla the errors where filtered as requested by the input parameters.");
            return;
        }
        try {
            File file;
            String json = objectMapper.writeValueAsString((Object)objectNode);
            File file2 = file = this.getFile(this.rClass, contextName, dateString);
            synchronized (file2) {
                try (FileWriter fw = new FileWriter(file, true);
                     BufferedWriter bw = new BufferedWriter(fw);
                     PrintWriter out = new PrintWriter(bw);){
                    out.println(json);
                    out.flush();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error exporting JSON error result", (Throwable)e);
        }
        logger.trace("-------------------------------------------------------\n\n\n\n\n");
    }

    protected R mapAndPublish(GR gr) throws Exception {
        R r = this.map(gr);
        List facets = r.getIdentificationFacets();
        for (Facet f : facets) {
            f.setAdditionalProperty(EXPORTED, (Object)EXPORTED_FROM_OLD_GCORE_IS);
        }
        return this.createOrUpdate(r);
    }

    public void export() {
        List<GR> all = this.getAll();
        logger.debug("-------------------------------------------------------");
        logger.debug("Going to export {} {}s as {}s", new Object[]{all.size(), this.grClass.getSimpleName(), this.rClass.getSimpleName()});
        logger.debug("-------------------------------------------------------");
        ArrayList<org.gcube.common.resources.gcore.Resource> failed = new ArrayList<org.gcube.common.resources.gcore.Resource>();
        for (org.gcube.common.resources.gcore.Resource gr : all) {
            try {
                Thread.sleep(300L);
                this.mapAndPublish(gr);
            }
            catch (Exception e) {
                failed.add(gr);
            }
        }
        this.notifyFailures(all.size(), failed);
    }
}

