package org.gcube.informationsystem.utils;

import java.io.IOException;

import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A utility class for working with JSON.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class JsonUtility {
	
	/** The logger for this class. */
	private static Logger logger = LoggerFactory.getLogger(JsonUtility.class);
	
	/**
	 * Parses a JSON string into a {@link JsonNode}.
	 *
	 * @param json The JSON string.
	 * @return The parsed {@code JsonNode}, or {@code null} if the input is null or empty.
	 * @throws IOException             if an I/O error occurs.
	 * @throws JsonProcessingException if a JSON processing error occurs.
	 */
	public static JsonNode getJsonNode(String json) throws JsonProcessingException, IOException {
		if(json==null || json.compareTo("")==0){
			return null;
		}
		logger.trace("Trying to get Jsonnode from {}", json);
		ObjectMapper mapper = new ObjectMapper();
		JsonNode jsonNode = mapper.readTree(json);
		return jsonNode;
	}
}
