package org.gcube.informationsystem.types.reference.entities;

import java.util.List;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.annotations.Final;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.impl.entities.ResourceTypeImpl;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.gcube.informationsystem.utils.Version;

/**
 * Defines the type of a {@link Resource}.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonDeserialize(as=ResourceTypeImpl.class)
@TypeMetadata(name = ResourceType.NAME, description = "This type provides information for the definition of any ResourceType", version = Version.MINIMAL_VERSION_STRING)
@Change(version = Version.MINIMAL_VERSION_STRING, description = Version.MINIMAL_VERSION_DESCRIPTION)
@Final
public interface ResourceType extends EntityType {
	
	/** The name of the ResourceType. */
	public static final String NAME = "ResourceType"; //ResourceType.class.getSimpleName();
	
	/** The property name for the facets. */
	public static final String FACETS_PROPERTY = "facets";
	/** The property name for the related resources. */
	public static final String RESOURCES_PROPERTY = "resources";
	
	/**
	 * Returns the list of facets associated with this resource type.
	 *
	 * @return A list of {@link LinkedEntity} objects representing the facets.
	 */
	@ISProperty(name = FACETS_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public List<LinkedEntity> getFacets();
	
	/**
	 * Returns the list of related resources for this resource type.
	 *
	 * @return A list of {@link LinkedEntity} objects representing the related resources.
	 */
	@ISProperty(name = RESOURCES_PROPERTY, readonly = false, mandatory = true, nullable = false)
	public List<LinkedEntity> getResources();
	
}
