package org.gcube.informationsystem.types.reference;

import static java.lang.annotation.ElementType.TYPE;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.informationsystem.utils.Version;

/**
 * An annotation for providing metadata about a type definition, such as its
 * name, description, and version.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Documented
@Target(TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface TypeMetadata {

	/**
	 * The name of the type.
	 *
	 * @return The type name.
	 */
	String name() default "";
	
	/**
	 * A description of the type.
	 *
	 * @return The type description.
	 */
	String description() default "";
	
	/**
	 * The version of the type.
	 *
	 * @return The version string.
	 */
	String version() default Version.MINIMAL_VERSION_STRING;
	
}
