package org.gcube.informationsystem.types.reference;

import static java.lang.annotation.ElementType.TYPE;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * A container for multiple {@link Change} annotations, allowing them to be
 * repeatable on a type.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Documented
@Target(TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Changelog {
	
	/**
	 * An array of {@link Change} annotations.
	 *
	 * @return The changes.
	 */
	Change[] value() default {};
			
}
