package org.gcube.informationsystem.types.reference;

import static java.lang.annotation.ElementType.TYPE;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Represents a single change in a type's version history.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Documented
@Target(TYPE)
@Repeatable(Changelog.class)
@Retention(RetentionPolicy.RUNTIME)
public @interface Change {

	/**
	 * The version in which the change was introduced.
	 *
	 * @return The version string.
	 */
	String version();
	
	/**
	 * A description of the change.
	 *
	 * @return The change description.
	 */
	String description();
	
}
