package org.gcube.informationsystem.types.impl.validator;

import java.util.ArrayList;
import java.util.List;

/**
 * A report containing the results of an attribute validation.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class AttributeValidatorReport {

    String fieldName;
    boolean valid;
    List<String> messages;

    /**
     * Returns the name of the validated field.
     *
     * @return The field name.
     */
    public String getFieldName() {
        return fieldName;
    }

    /**
     * Sets the name of the validated field.
     *
     * @param fieldName The field name.
     */
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    /**
     * Checks if the validation was successful.
     *
     * @return {@code true} if the attribute is valid, {@code false} otherwise.
     */
    public boolean isValid() {
        return valid;
    }

    /**
     * Sets the validity status of the validation.
     *
     * @param valid The validity status.
     */
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    /**
     * Returns the list of validation messages.
     *
     * @return A list of messages.
     */
    public List<String> getMessages() {
        return messages;
    }

    /**
     * Adds a validation message to the report.
     *
     * @param message The message to add.
     */
    public void addMessage(String message) {
        if(this.messages==null) {
            this.messages = new ArrayList<>();
        }
        this.messages.add(message);
    }

}
