/**
 * 
 */
package org.gcube.informationsystem.types.impl.properties;

import java.util.Objects;

import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.impl.properties.PropertyElementImpl;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

/**
 * The default implementation of the {@link LinkedEntity} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=LinkedEntity.NAME)
public final class LinkedEntityImpl extends PropertyElementImpl implements LinkedEntity {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = -531978995960170532L;
	
	/** The source of the link. */
	protected String source;
	/** The relation of the link. */
	protected String relation;
	/** The target of the link. */
	protected String target;
	/** The description of the link. */
	protected String description;
	/** The minimum cardinality. */
	protected Integer min;
	/** The maximum cardinality. */
	protected Integer max;

	/**
	 * Default constructor.
	 */
	public LinkedEntityImpl() {
		super();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getSource() {
		return source;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSource(String source) {
		this.source = source;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRelation() {
		return relation;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRelation(String relation) {
		this.relation = relation;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTarget() {
		return target;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTarget(String target) {
		this.target = target;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getDescription() {
		return description;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMin() {
		return min;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMin(Integer min) {
		this.min = min;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getMax() {
		return max;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setMax(Integer max) {
		if(max==null || max<=0) {
			this.max = null;
		}else {
			this.max = max;
		}
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public int hashCode() {
		return Objects.hash(source, relation, target, min, max, description);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LinkedEntityImpl other = (LinkedEntityImpl) obj;
		return Objects.equals(source, other.source) &&
			   Objects.equals(relation, other.relation) &&
			   Objects.equals(target, other.target) &&
			   Objects.equals(min, other.min) &&
			   Objects.equals(max, other.max) &&
			   Objects.equals(description, other.description);
	}
	
	/**
	 * Compares two integers.
	 *
	 * @param thisInt  The first integer.
	 * @param otherInt The second integer.
	 * @return The result of the comparison.
	 */
	protected int compareIntegers(Integer thisInt, Integer otherInt) {
		Integer thisInteger = thisInt == null ? Integer.MAX_VALUE : thisInt;
		Integer otherInteger = otherInt == null ? Integer.MAX_VALUE : otherInt;
		return thisInteger.compareTo(otherInteger);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public int compareTo(LinkedEntity other) {
		if (this == other) {
			return 0;
		}
		if (other == null) {
			return -1;
		}
		if (getClass() != other.getClass()) {
			return -1;
		}
		
		LinkedEntityImpl o = (LinkedEntityImpl) other;
		
		int ret = 0;
		ret = source.compareTo(o.source);
		if(ret != 0) {
			return ret;
		}
		
		ret = relation.compareTo(o.relation);
		if(ret != 0) {
			return ret;
		}
		
		ret = target.compareTo(o.target);
		if(ret != 0) {
			return ret;
		}
		
		ret = compareIntegers(max, o.max);
		if(ret != 0) {
			return ret;
		}
		
		ret = compareIntegers(min, o.min);
		if(ret != 0) {
			return ret;
		}
		
		return description.compareTo(o.description);
		
	}
}
