package org.gcube.informationsystem.types.impl.entities;

import java.util.Set;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;

/**
 * The default implementation of the {@link FacetType} interface.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@JsonTypeName(value=FacetType.NAME)
public final class FacetTypeImpl extends EntityTypeImpl implements FacetType {

	/**
	 * The serial version UID.
	 */
	private static final long serialVersionUID = 6268161046955738969L;
	
	/** The properties of the facet type. */
	protected Set<PropertyDefinition> properties;
	
	/**
	 * Default constructor.
	 */
	protected FacetTypeImpl() {
		super();
	}
	
	/**
	 * Constructs a new {@code FacetTypeImpl} from a class.
	 *
	 * @param clz The class.
	 */
	public FacetTypeImpl(Class<? extends Facet> clz) {
		super(clz);
		this.extendedTypes = retrieveSuperClasses(clz, Facet.class, Entity.NAME);
		this.properties = retrieveListOfProperties(clz);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Set<PropertyDefinition> getProperties() {
		return properties;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@JsonIgnore
	public AccessType getAccessType() {
		return AccessType.FACET;
	}
	
}
