package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;

/**
 * Defines a single entry in a {@link ResourceSchema}, specifying a facet that
 * composes the resource.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ResourceSchemaEntry {

	/**
	 * @return the relation
	 */
	@SuppressWarnings("rawtypes")
	@JsonProperty
	Class<? extends ConsistsOf> relation() default ConsistsOf.class;
	/**
	 * @return the facet
	 */
	@JsonProperty
	Class<? extends Facet> facet() default Facet.class;
	
	/**
	 * @return the description
	 */
	@JsonProperty
	String description() default "";
	
	/**
	 * @return the min
	 */
	@JsonProperty
	int min() default 0;
	/**
	 * @return the max
	 */
	@JsonProperty
	int max() default -1;
	

}
