package org.gcube.informationsystem.types.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines the schema for a resource, specifying its constituent facets and
 * relationships with other resources.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ResourceSchema {

	/**
	 * The facets that make up this resource.
	 *
	 * @return an array of facets
	 */
	ResourceSchemaEntry[] facets() default {};
	
	/**
	 * The resources that are related to this resource.
	 *
	 * @return an array of related resources
	 */
	RelatedResourcesEntry[] resources() default {};
}
